/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.metadata.ReflectiveXmlRpcMetaDataHandler;
import org.apache.xmlrpc.metadata.Util;
import org.apache.xmlrpc.metadata.XmlRpcListableHandlerMapping;
import org.apache.xmlrpc.metadata.XmlRpcMetaDataHandler;
import org.apache.xmlrpc.server.ReflectiveXmlRpcHandler;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;

public abstract class AbstractReflectiveHandlerMapping
implements XmlRpcListableHandlerMapping {
    private final TypeConverterFactory typeConverterFactory;
    private final boolean instanceIsStateless;
    protected Map handlerMap = new HashMap();
    private AuthenticationHandler authenticationHandler;
    private InitializationHandler initializationHandler;
    static /* synthetic */ Class class$java$lang$Object;

    protected AbstractReflectiveHandlerMapping(TypeConverterFactory pTypeConverterFactory, boolean pInstanceIsStateless) {
        this.typeConverterFactory = pTypeConverterFactory;
        this.instanceIsStateless = pInstanceIsStateless;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public void setAuthenticationHandler(AuthenticationHandler pAuthenticationHandler) {
        this.authenticationHandler = pAuthenticationHandler;
    }

    public InitializationHandler getInitializationHandler() {
        return this.initializationHandler;
    }

    public void setInitializationHandler(InitializationHandler pInitializationHandler) {
        this.initializationHandler = pInitializationHandler;
    }

    protected void registerPublicMethods(Map pMap, String pKey, Class pType) throws XmlRpcException {
        Method[] mArray;
        String name;
        HashMap<String, Method[]> map = new HashMap<String, Method[]>();
        Method[] methods = pType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getReturnType() == Void.TYPE || method.getDeclaringClass() == (class$java$lang$Object == null ? AbstractReflectiveHandlerMapping.class$("java.lang.Object") : class$java$lang$Object)) continue;
            name = pKey + "." + method.getName();
            Method[] oldMArray = (Method[])map.get(name);
            if (oldMArray == null) {
                mArray = new Method[]{method};
            } else {
                mArray = new Method[oldMArray.length + 1];
                System.arraycopy(oldMArray, 0, mArray, 0, oldMArray.length);
                mArray[oldMArray.length] = method;
            }
            map.put(name, mArray);
        }
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            name = (String)entry.getKey();
            mArray = (Method[])entry.getValue();
            pMap.put(name, this.newXmlRpcHandler(pType, mArray));
        }
    }

    protected XmlRpcHandler newXmlRpcHandler(Class pClass, Method[] pMethods) throws XmlRpcException {
        String[][] sig = this.getSignature(pMethods);
        String help = this.getMethodHelp(pClass, pMethods);
        if (sig == null || help == null) {
            return new ReflectiveXmlRpcHandler(this, this.typeConverterFactory, pClass, this.instanceIsStateless, pMethods);
        }
        return new ReflectiveXmlRpcMetaDataHandler(this, this.typeConverterFactory, pClass, this.instanceIsStateless, pMethods, sig, help);
    }

    protected String[][] getSignature(Method[] pMethods) {
        return Util.getSignature(pMethods);
    }

    protected String getMethodHelp(Class pClass, Method[] pMethods) {
        return Util.getMethodHelp(pClass, pMethods);
    }

    public XmlRpcHandler getHandler(String pHandlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
        XmlRpcHandler result = (XmlRpcHandler)this.handlerMap.get(pHandlerName);
        if (result == null) {
            throw new XmlRpcNoSuchHandlerException("No such handler: " + pHandlerName);
        }
        return result;
    }

    public String[] getListMethods() throws XmlRpcException {
        ArrayList list = new ArrayList();
        Iterator iter = this.handlerMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof XmlRpcMetaDataHandler)) continue;
            list.add(entry.getKey());
        }
        return list.toArray(new String[list.size()]);
    }

    public String getMethodHelp(String pHandlerName) throws XmlRpcException {
        XmlRpcHandler h = this.getHandler(pHandlerName);
        if (h instanceof XmlRpcMetaDataHandler) {
            return ((XmlRpcMetaDataHandler)h).getMethodHelp();
        }
        throw new XmlRpcNoSuchHandlerException("No help available for method: " + pHandlerName);
    }

    public String[][] getMethodSignature(String pHandlerName) throws XmlRpcException {
        XmlRpcHandler h = this.getHandler(pHandlerName);
        if (h instanceof XmlRpcMetaDataHandler) {
            return ((XmlRpcMetaDataHandler)h).getSignatures();
        }
        throw new XmlRpcNoSuchHandlerException("No metadata available for method: " + pHandlerName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface InitializationHandler {
        public void init(XmlRpcRequest var1, Object var2) throws XmlRpcException;
    }

    public static interface AuthenticationHandler {
        public boolean isAuthorized(XmlRpcRequest var1) throws XmlRpcException;
    }
}

