/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcTransportImpl;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.parser.XmlRpcResponseParser;
import org.apache.xmlrpc.serializer.XmlRpcWriter;
import org.apache.xmlrpc.util.SAXParsers;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlRpcStreamTransport
extends XmlRpcTransportImpl {
    protected RequestWriter newRequestWriter(XmlRpcRequest pRequest) throws XmlRpcException {
        return new RequestWriter(pRequest);
    }

    protected XmlRpcStreamTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    protected abstract void close() throws XmlRpcClientException;

    protected abstract boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig var1);

    protected abstract void writeRequest(RequestWriter var1) throws XmlRpcException;

    protected abstract InputStream getInputStream() throws XmlRpcException;

    protected boolean isCompressingRequest(XmlRpcStreamRequestConfig pConfig) {
        return pConfig.isEnabledForExtensions() && pConfig.isGzipCompressing();
    }

    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        XmlRpcStreamRequestConfig config = (XmlRpcStreamRequestConfig)pRequest.getConfig();
        boolean closed = false;
        try {
            RequestWriter writer = this.newRequestWriter(pRequest);
            this.writeRequest(writer);
            InputStream istream = this.getInputStream();
            if (this.isResponseGzipCompressed(config)) {
                istream = new GZIPInputStream(istream);
            }
            Object result = this.readResponse(config, istream);
            closed = true;
            this.close();
            Object object = result;
            return object;
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to read servers response: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (!closed) {
                try {
                    this.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    protected XMLReader newXMLReader() throws XmlRpcException {
        return SAXParsers.newXMLReader();
    }

    protected Object readResponse(XmlRpcStreamRequestConfig pConfig, InputStream pStream) throws XmlRpcException {
        XmlRpcResponseParser xp;
        InputSource isource = new InputSource(pStream);
        XMLReader xr = this.newXMLReader();
        try {
            xp = new XmlRpcResponseParser(pConfig, this.getClient().getTypeFactory());
            xr.setContentHandler((ContentHandler)xp);
            xr.parse(isource);
        }
        catch (SAXException e) {
            throw new XmlRpcClientException("Failed to parse servers response: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to read servers response: " + e.getMessage(), e);
        }
        if (xp.isSuccess()) {
            return xp.getResult();
        }
        throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage());
    }

    protected class RequestWriter {
        private final XmlRpcRequest request;

        protected RequestWriter(XmlRpcRequest pRequest) {
            this.request = pRequest;
        }

        protected XmlRpcRequest getRequest() {
            return this.request;
        }

        protected void write(OutputStream pStream) throws XmlRpcException {
            XmlRpcStreamRequestConfig config = (XmlRpcStreamRequestConfig)this.request.getConfig();
            if (XmlRpcStreamTransport.this.isCompressingRequest(config)) {
                try {
                    GZIPOutputStream gStream = new GZIPOutputStream(pStream);
                    this.writeUncompressed(gStream);
                    pStream.close();
                    pStream = null;
                }
                catch (IOException e) {
                    throw new XmlRpcException("Failed to write request: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    if (pStream != null) {
                        try {
                            pStream.close();
                        }
                        catch (Throwable ignore) {}
                    }
                }
            }
            this.writeUncompressed(pStream);
        }

        protected void writeUncompressed(OutputStream pStream) throws XmlRpcException {
            XmlRpcStreamConfig config = (XmlRpcStreamConfig)this.request.getConfig();
            try {
                ContentHandler h = XmlRpcStreamTransport.this.getClient().getXmlWriterFactory().getXmlWriter(config, pStream);
                XmlRpcWriter xw = new XmlRpcWriter(config, h, XmlRpcStreamTransport.this.getClient().getTypeFactory());
                xw.write(this.request);
                pStream.close();
                pStream = null;
            }
            catch (SAXException e) {
                Exception ex = e.getException();
                if (ex != null && ex instanceof XmlRpcException) {
                    throw (XmlRpcException)ex;
                }
                throw new XmlRpcClientException("Failed to send request: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new XmlRpcException("Failed to write request: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (pStream != null) {
                    try {
                        pStream.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
    }
}

