/*
 * Decompiled with CFR 0.152.
 */
package repackage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Repackager {
    private List _fromPackages = new ArrayList();
    private List _toPackages = new ArrayList();
    private Matcher[] _fromMatchers;
    private String[] _toPackageNames;

    public Repackager(String repackageSpecs) {
        boolean swapped;
        ArrayList repackages = Repackager.splitPath(repackageSpecs, ';');
        do {
            swapped = false;
            int i = 1;
            while (i < repackages.size()) {
                String spec1 = (String)repackages.get(i - 1);
                String spec2 = (String)repackages.get(i);
                if (spec1.indexOf(58) < spec2.indexOf(58)) {
                    repackages.set(i - 1, spec2);
                    repackages.set(i, spec1);
                    swapped = true;
                }
                ++i;
            }
        } while (swapped);
        int i = 0;
        while (i < repackages.size()) {
            String spec = (String)repackages.get(i);
            int j = spec.indexOf(58);
            if (j < 0 || spec.indexOf(58, j + 1) >= 0) {
                throw new RuntimeException("Illegal repackage specification: " + spec);
            }
            String from = spec.substring(0, j);
            String to = spec.substring(j + 1);
            this._fromPackages.add(Repackager.splitPath(from, '.'));
            this._toPackages.add(Repackager.splitPath(to, '.'));
            ++i;
        }
        this._fromMatchers = new Matcher[this._fromPackages.size() * 2];
        this._toPackageNames = new String[this._fromPackages.size() * 2];
        this.addPatterns('.', 0);
        this.addPatterns('/', this._fromPackages.size());
    }

    void addPatterns(char sep, int off) {
        int i = 0;
        while (i < this._fromPackages.size()) {
            List from = (List)this._fromPackages.get(i);
            List to = (List)this._toPackages.get(i);
            String pattern = "";
            int j = 0;
            while (j < from.size()) {
                if (j > 0) {
                    pattern = pattern + "\\" + sep;
                }
                pattern = pattern + from.get(j);
                ++j;
            }
            String toPackage = "";
            int j2 = 0;
            while (j2 < to.size()) {
                if (j2 > 0) {
                    toPackage = toPackage + sep;
                }
                toPackage = toPackage + to.get(j2);
                ++j2;
            }
            this._fromMatchers[off + i] = Pattern.compile(pattern).matcher(null);
            this._toPackageNames[off + i] = toPackage;
            ++i;
        }
    }

    public void repackage(StringBuffer sb) {
        int i = 0;
        while (i < this._fromMatchers.length) {
            Matcher matcher = this._fromMatchers[i];
            matcher.reset(sb);
            while (matcher.find()) {
                sb.replace(matcher.start(), matcher.end(), this._toPackageNames[i]);
            }
            ++i;
        }
    }

    public List getFromPackages() {
        return this._fromPackages;
    }

    public List getToPackages() {
        return this._toPackages;
    }

    public static ArrayList splitPath(String path, char separator) {
        int i;
        ArrayList<String> components = new ArrayList<String>();
        while ((i = path.indexOf(separator)) >= 0) {
            components.add(path.substring(0, i));
            path = path.substring(i + 1);
        }
        if (path.length() > 0) {
            components.add(path);
        }
        return components;
    }

    public static String dirForPath(String path) {
        return new File(path).getParent();
    }
}

