/*
 * Decompiled with CFR 0.152.
 */
package repackage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import repackage.Repackager;

public class Repackage {
    private File _sourceBase;
    private File _targetBase;
    private List _fromPackages;
    private List _toPackages;
    private Pattern _packagePattern;
    private Repackager _repackager;
    private Map _movedDirs;
    private List _moveAlongFiles;

    public static void main(String[] args) throws Exception {
        new Repackage().repackage(args);
    }

    public void repackage(String[] args) throws Exception {
        if (args.length != 2 || !args[0].equals("-repackage")) {
            throw new RuntimeException("Usage: repackage -repackage [spec]");
        }
        this._repackager = new Repackager(args[1]);
        this._fromPackages = this._repackager.getFromPackages();
        this._toPackages = this._repackager.getToPackages();
        this._packagePattern = Pattern.compile("^\\s*package\\s+((?:\\w|\\.)*)\\s*;", 8);
        this._moveAlongFiles = new ArrayList();
        this._movedDirs = new HashMap();
        File currentDir = new File(".");
        File buildDir = new File(currentDir, "build");
        File repackageDir = new File(buildDir, "repackage");
        System.out.println("Deleting repackage dir ...");
        this.recursiveDelete(repackageDir);
        repackageDir.mkdirs();
        ArrayList files = new ArrayList();
        this.fillFiles(files, currentDir);
        System.out.println("Repackaging " + files.size() + " files ...");
        int prefixLength = currentDir.getCanonicalPath().length();
        this._sourceBase = currentDir;
        this._targetBase = repackageDir;
        int i = 0;
        while (i < files.size()) {
            File from = (File)files.get(i);
            String name = from.getCanonicalPath().substring(prefixLength + 1);
            this.repackageFile(name);
            ++i;
        }
        this.finishMovingFiles();
    }

    public void repackageFile(String name) throws IOException {
        if (name.endsWith(".java")) {
            this.repackageJavaFile(name);
        } else if (name.endsWith(".xsdconfig")) {
            this.repackageNonJavaFile(name);
        } else if (name.startsWith("bin" + File.separatorChar)) {
            this.repackageNonJavaFile(name);
        } else {
            this.moveAlongWithJavaFiles(name);
        }
    }

    public void moveAlongWithJavaFiles(String name) {
        this._moveAlongFiles.add(name);
    }

    public void finishMovingFiles() throws IOException {
        Iterator i = this._moveAlongFiles.iterator();
        while (i.hasNext()) {
            String name;
            String toName = name = (String)i.next();
            String srcDir = Repackager.dirForPath(name);
            String toDir = (String)this._movedDirs.get(srcDir);
            if (toDir != null) {
                toName = new File(toDir, new File(name).getName()).toString();
            }
            if (name.endsWith(".html")) {
                this.repackageNonJavaFile(name, toName);
                continue;
            }
            this.copyFile(new File(this._sourceBase, name), new File(this._targetBase, toName));
        }
    }

    public void repackageNonJavaFile(String name) throws IOException {
        StringBuffer sb = this.readFile(new File(this._sourceBase, name));
        this._repackager.repackage(sb);
        this.writeFile(new File(this._targetBase, name), sb);
    }

    public void repackageNonJavaFile(String sourceName, String targetName) throws IOException {
        StringBuffer sb = this.readFile(new File(this._sourceBase, sourceName));
        this._repackager.repackage(sb);
        this.writeFile(new File(this._targetBase, targetName), sb);
    }

    public void repackageJavaFile(String name) throws IOException {
        StringBuffer sb = this.readFile(new File(this._sourceBase, name));
        Matcher packageMatcher = this._packagePattern.matcher(sb);
        if (packageMatcher.find()) {
            boolean swapped;
            String pkg = packageMatcher.group(1);
            int pkgStart = packageMatcher.start(1);
            int pkgEnd = packageMatcher.end(1);
            if (packageMatcher.find()) {
                throw new RuntimeException("Two package specifications found: " + name);
            }
            ArrayList filePath = Repackager.splitPath(name, File.separatorChar);
            String srcDir = Repackager.dirForPath(name);
            do {
                swapped = false;
                int i = 1;
                while (i < filePath.size()) {
                    String spec1 = (String)filePath.get(i - 1);
                    String spec2 = (String)filePath.get(i);
                    if (spec1.indexOf(58) < spec2.indexOf(58)) {
                        filePath.set(i - 1, spec2);
                        filePath.set(i, spec1);
                        swapped = true;
                    }
                    ++i;
                }
            } while (swapped);
            ArrayList pkgPath = Repackager.splitPath(pkg, '.');
            int f = filePath.size() - 2;
            int i = pkgPath.size() - 1;
            while (i >= 0) {
                if (!pkgPath.get(i).equals(filePath.get(f--))) {
                    throw new RuntimeException("Package spec differs from file path: " + name);
                }
                --i;
            }
            List changeTo = null;
            List changeFrom = null;
            int i2 = 0;
            while (i2 < this._fromPackages.size()) {
                block17: {
                    List from = (List)this._fromPackages.get(i2);
                    if (from.size() <= pkgPath.size()) {
                        int j = 0;
                        while (j < from.size()) {
                            if (from.get(j).equals(pkgPath.get(j))) {
                                ++j;
                                continue;
                            }
                            break block17;
                        }
                        changeFrom = from;
                        changeTo = (List)this._toPackages.get(i2);
                        break;
                    }
                }
                ++i2;
            }
            if (changeTo != null) {
                String newPkg = "";
                String newName = "";
                int i3 = 0;
                while (i3 < changeTo.size()) {
                    if (i3 > 0) {
                        newPkg = newPkg + ".";
                        newName = newName + File.separatorChar;
                    }
                    newPkg = newPkg + changeTo.get(i3);
                    newName = newName + changeTo.get(i3);
                    ++i3;
                }
                int i4 = filePath.size() - pkgPath.size() - 2;
                while (i4 >= 0) {
                    newName = (String)filePath.get(i4) + File.separatorChar + newName;
                    --i4;
                }
                int i5 = changeFrom.size();
                while (i5 < pkgPath.size()) {
                    newName = newName + File.separatorChar + (String)pkgPath.get(i5);
                    newPkg = newPkg + '.' + (String)pkgPath.get(i5);
                    ++i5;
                }
                newName = newName + File.separatorChar + (String)filePath.get(filePath.size() - 1);
                sb.replace(pkgStart, pkgEnd, newPkg);
                name = newName;
                String newDir = Repackager.dirForPath(name);
                if (!srcDir.equals(newDir)) {
                    this._movedDirs.put(srcDir, newDir);
                }
            }
        }
        this._repackager.repackage(sb);
        this.writeFile(new File(this._targetBase, name), sb);
    }

    void writeFile(File f, StringBuffer chars) throws IOException {
        f.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f);
        OutputStreamWriter w = new OutputStreamWriter(out);
        StringReader r = new StringReader(chars.toString());
        this.copy(r, w);
        ((Reader)r).close();
        ((Writer)w).close();
        ((OutputStream)out).close();
    }

    StringBuffer readFile(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        InputStreamReader r = new InputStreamReader(in);
        StringWriter w = new StringWriter();
        this.copy(r, w);
        w.close();
        ((Reader)r).close();
        ((InputStream)in).close();
        return w.getBuffer();
    }

    public void copyFile(File from, File to) throws IOException {
        to.getParentFile().mkdirs();
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        this.copy(in, out);
        out.close();
        in.close();
    }

    public void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[16384];
        while ((n = in.read(buffer, 0, buffer.length)) >= 0) {
            out.write(buffer, 0, n);
        }
    }

    public void copy(Reader r, Writer w) throws IOException {
        int n;
        char[] buffer = new char[16384];
        while ((n = r.read(buffer, 0, buffer.length)) >= 0) {
            w.write(buffer, 0, n);
        }
    }

    public void fillFiles(ArrayList files, File file) throws IOException {
        if (!file.isDirectory()) {
            files.add(file);
            return;
        }
        if (file.getName().equals("build")) {
            return;
        }
        if (file.getName().equals("CVS")) {
            return;
        }
        String[] entries = file.list();
        int i = 0;
        while (i < entries.length) {
            this.fillFiles(files, new File(file, entries[i]));
            ++i;
        }
    }

    public void recursiveDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] entries = file.list();
            int i = 0;
            while (i < entries.length) {
                this.recursiveDelete(new File(file, entries[i]));
                ++i;
            }
        }
        file.delete();
    }
}

