/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.math.BigDecimal;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.values.JavaDecimalHolder;
import org.apache.xmlbeans.impl.values.XmlObjectBase;

public abstract class JavaDecimalHolderEx
extends JavaDecimalHolder {
    private SchemaType _schemaType;

    public SchemaType schemaType() {
        return this._schemaType;
    }

    public JavaDecimalHolderEx(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    protected void set_text(String s) {
        if (this._validateOnSet()) {
            JavaDecimalHolderEx.validateLexical(s, this._schemaType, XmlObjectBase._voorVc);
        }
        BigDecimal v = null;
        try {
            v = new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            XmlObjectBase._voorVc.invalid("Invalid Decimal");
        }
        if (this._validateOnSet()) {
            JavaDecimalHolderEx.validateValue(v, this._schemaType, XmlObjectBase._voorVc);
        }
        super.set_BigDecimal(v);
    }

    protected void set_BigDecimal(BigDecimal v) {
        if (this._validateOnSet()) {
            JavaDecimalHolderEx.validateValue(v, this._schemaType, XmlObjectBase._voorVc);
        }
        super.set_BigDecimal(v);
    }

    public static void validateLexical(String v, SchemaType sType, ValidationContext context) {
        JavaDecimalHolder.validateLexical(v, context);
        if (sType.hasPatternFacet() && !sType.matchPatternFacet(v)) {
            context.invalid("Decimal (" + v + ") does not match pattern for " + QNameHelper.readable(sType));
        }
    }

    public static void validateValue(BigDecimal v, SchemaType sType, ValidationContext context) {
        BigDecimal m;
        BigDecimal m2;
        BigDecimal m3;
        BigDecimal m4;
        XmlAnySimpleType mine;
        XmlAnySimpleType td;
        XmlAnySimpleType fd = sType.getFacet(8);
        if (fd != null) {
            int scale = ((XmlObjectBase)((Object)fd)).bigIntegerValue().intValue();
            if (v.scale() > scale) {
                context.invalid("Decimal fractional digits (" + v.scale() + ") does not match " + "fractional digits facet (" + scale + ") for " + QNameHelper.readable(sType));
                return;
            }
        }
        if ((td = sType.getFacet(7)) != null) {
            String temp = v.unscaledValue().toString();
            int tdf = ((XmlObjectBase)((Object)td)).bigIntegerValue().intValue();
            int len = temp.length();
            if (len > 0 && temp.charAt(0) == '-') {
                --len;
            }
            if (len > tdf) {
                context.invalid("Decimal total digits (" + temp + ") is greater than " + "total digits facet (" + tdf + ") for " + QNameHelper.readable(sType));
                return;
            }
        }
        if ((mine = sType.getFacet(3)) != null && v.compareTo(m4 = ((XmlObjectBase)((Object)mine)).bigDecimalValue()) <= 0) {
            context.invalid("Decimal (" + v + ") is less than or equal to " + "min exclusive facet (" + m4 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType mini = sType.getFacet(4);
        if (mini != null && v.compareTo(m3 = ((XmlObjectBase)((Object)mini)).bigDecimalValue()) < 0) {
            context.invalid("Decimal (" + v + ") is less than " + "min inclusive facet (" + m3 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType maxi = sType.getFacet(5);
        if (maxi != null && v.compareTo(m2 = ((XmlObjectBase)((Object)maxi)).bigDecimalValue()) > 0) {
            context.invalid("Decimal (" + v + ") is greater than " + "max inclusive facet (" + m2 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType maxe = sType.getFacet(6);
        if (maxe != null && v.compareTo(m = ((XmlObjectBase)((Object)maxe)).bigDecimalValue()) >= 0) {
            context.invalid("Decimal (" + v + ") is greater than or equal to " + "max exclusive facet (" + m + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType[] vals = sType.getEnumerationValues();
        if (vals != null) {
            int i = 0;
            while (i < vals.length) {
                if (v.equals(((XmlObjectBase)((Object)vals[i])).bigDecimalValue())) {
                    return;
                }
                ++i;
            }
            context.invalid("Decimal (" + v + ") does not match any enumeration values for " + QNameHelper.readable(sType));
        }
    }

    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        JavaDecimalHolderEx.validateLexical(lexical, this.schemaType(), ctx);
        JavaDecimalHolderEx.validateValue(this.bigDecimalValue(), this.schemaType(), ctx);
    }
}

