/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.impl.config.InterfaceExtension;
import org.apache.xmlbeans.impl.config.PrePostExtension;
import org.apache.xmlbeans.impl.config.SchemaConfig;

public class ExtensionHolder {
    private List _interfaceExtensions = new ArrayList();
    private List _prePostExtensions = new ArrayList();

    ExtensionHolder() {
    }

    void addInterfaceExtension(InterfaceExtension ext) {
        if (ext == null) {
            return;
        }
        this._interfaceExtensions.add(ext);
    }

    void addPrePostExtension(PrePostExtension ext) {
        if (ext == null) {
            return;
        }
        this._prePostExtensions.add(ext);
    }

    void secondPhaseValidation() {
        HashMap<MethodSignature, MethodSignature> methodSignatures = new HashMap<MethodSignature, MethodSignature>();
        int i = 0;
        while (i < this._interfaceExtensions.size()) {
            InterfaceExtension interfaceExtension = (InterfaceExtension)this._interfaceExtensions.get(i);
            int j = 0;
            while (j < interfaceExtension.getInterfaceMethodCount()) {
                MethodSignature ms = new MethodSignature(interfaceExtension.getInterfaceName(), interfaceExtension.getInterfaceMethod(j));
                if (methodSignatures.containsKey(ms)) {
                    MethodSignature ms2 = (MethodSignature)methodSignatures.get(ms);
                    SchemaConfig.error("Colliding methods '" + ms.getSignature() + "' in interfaces " + ms.getInterfaceName() + " and " + ms2.getInterfaceName() + ".", null);
                    return;
                }
                methodSignatures.put(ms, ms);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._prePostExtensions.size() - 1) {
            PrePostExtension a = (PrePostExtension)this._prePostExtensions.get(i2);
            int j = 1;
            while (j < this._prePostExtensions.size()) {
                PrePostExtension b = (PrePostExtension)this._prePostExtensions.get(j);
                if (a.hasNameSetIntersection(b)) {
                    SchemaConfig.error("The applicable domain for handler '" + a.getHandlerNameForJavaSource() + "' intersects with the one for '" + b.getHandlerNameForJavaSource() + "'.", null);
                }
                ++j;
            }
            ++i2;
        }
    }

    void normalize() {
        throw new RuntimeException("NYI");
    }

    public void verifyInterfaceNameCollisions(Set genedUsedNames) {
        int i = 0;
        while (i < this._interfaceExtensions.size()) {
            String handlerClassName;
            InterfaceExtension interfaceExtension = (InterfaceExtension)this._interfaceExtensions.get(i);
            if (genedUsedNames.contains(interfaceExtension.getInterfaceNameForJavaSource().toLowerCase())) {
                SchemaConfig.error("Extension interface '" + interfaceExtension.getInterfaceNameForJavaSource() + "' creates a name collision with one of the generated interfaces or classes.", null);
            }
            if ((handlerClassName = interfaceExtension.getHandlerNameForJavaSource()) != null && genedUsedNames.contains(handlerClassName.toLowerCase())) {
                SchemaConfig.error("Handler class '" + handlerClassName + "' creates a name collision with one of the generated interfaces or classes.", null);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._prePostExtensions.size()) {
            PrePostExtension prePostExtension = (PrePostExtension)this._prePostExtensions.get(i2);
            String handlerClassName = prePostExtension.getHandlerNameForJavaSource();
            if (handlerClassName != null && genedUsedNames.contains(handlerClassName.toLowerCase())) {
                SchemaConfig.error("Handler class '" + prePostExtension.getHandlerNameForJavaSource() + "' creates a name collision with one of the generated interfaces or classes.", null);
            }
            ++i2;
        }
    }

    ExtensionHolder extensionHolderFor(String javaName) {
        int i = 0;
        while (i < this._interfaceExtensions.size()) {
            InterfaceExtension interfaceExtension = (InterfaceExtension)this._interfaceExtensions.get(i);
            if (interfaceExtension.contains(javaName)) {
                return this;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._prePostExtensions.size()) {
            PrePostExtension prePostExtension = (PrePostExtension)this._prePostExtensions.get(i2);
            if (prePostExtension.contains(javaName)) {
                return this;
            }
            ++i2;
        }
        return null;
    }

    public List getInterfaceExtensionsFor(String fullJavaName) {
        ArrayList<InterfaceExtension> result = new ArrayList<InterfaceExtension>();
        int i = 0;
        while (i < this._interfaceExtensions.size()) {
            InterfaceExtension intfExt = (InterfaceExtension)this._interfaceExtensions.get(i);
            if (intfExt.contains(fullJavaName)) {
                result.add(intfExt);
            }
            ++i;
        }
        return result;
    }

    public PrePostExtension getPrePostExtensionsFor(String fullJavaName) {
        int i = 0;
        while (i < this._prePostExtensions.size()) {
            PrePostExtension prePostExt = (PrePostExtension)this._prePostExtensions.get(i);
            if (prePostExt.contains(fullJavaName)) {
                return prePostExt;
            }
            ++i;
        }
        return null;
    }

    private static class MethodSignature {
        private String _intfName;
        private Method _method;

        MethodSignature(String intfName, Method method) {
            if (intfName == null || method == null) {
                throw new IllegalArgumentException("Interface: " + intfName + " method: " + method);
            }
            this._intfName = intfName;
            this._method = method;
        }

        String getInterfaceName() {
            return this._intfName;
        }

        String getSignature() {
            String sig = "";
            Class<?>[] paramTypes = this._method.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                Class<?> paramType = paramTypes[i];
                sig = sig + (i == 0 ? "" : " ,") + paramType.getName();
                ++i;
            }
            return this._method.getName() + "(" + sig + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature ms = (MethodSignature)o;
            if (!ms._method.getName().equals(this._method.getName())) {
                return false;
            }
            Class<?>[] paramTypes = this._method.getParameterTypes();
            Class<?>[] msParamTypes = this._method.getParameterTypes();
            if (msParamTypes.length != paramTypes.length) {
                return false;
            }
            int i = 0;
            while (i < paramTypes.length) {
                if (msParamTypes[i] != paramTypes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            int hash = this._method.getName().hashCode();
            Class<?>[] paramTypes = this._method.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                hash *= 19;
                hash += paramTypes[i].hashCode();
                ++i;
            }
            return hash;
        }
    }
}

