/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.util.WeakHashMap;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdResolver {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$IdResolver == null ? (class$org$apache$xml$security$utils$IdResolver = IdResolver.class$("org.apache.xml.security.utils.IdResolver")) : class$org$apache$xml$security$utils$IdResolver).getName());
    static WeakHashMap docMap = new WeakHashMap();
    static /* synthetic */ Class class$org$apache$xml$security$utils$IdResolver;

    private IdResolver() {
    }

    public static void registerElementById(Element element, String string) {
        Document document = element.getOwnerDocument();
        WeakHashMap<String, Element> weakHashMap = (WeakHashMap<String, Element>)docMap.get(document);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<String, Element>();
            docMap.put(document, weakHashMap);
        }
        weakHashMap.put(string, element);
    }

    public static void registerElementById(Element element, Attr attr) {
        IdResolver.registerElementById(element, attr.getNodeValue());
    }

    public static Element getElementById(Document document, String string) {
        Element element = null;
        element = IdResolver.getElementByIdType(document, string);
        if (element != null) {
            log.debug((Object)("I could find an Element using the simple getElementByIdType method: " + element.getTagName()));
            return element;
        }
        element = IdResolver.getElementByIdUsingDOM(document, string);
        if (element != null) {
            log.debug((Object)("I could find an Element using the simple getElementByIdUsingDOM method: " + element.getTagName()));
            return element;
        }
        element = IdResolver.getElementByIdInDSNamespace(document, string);
        if (element != null) {
            log.debug((Object)("Found an Element using an insecure Id/ID/id search method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdInXENCNamespace(document, string);
        if (element != null) {
            log.debug((Object)("I could find an Element using the advanced xenc:Namespace searcher method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdInSOAPSignatureNamespace(document, string);
        if (element != null) {
            log.debug((Object)("I could find an Element using the advanced SOAP-SEC:id searcher method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdInXKMSNamespace(document, string);
        if (element != null) {
            log.debug((Object)("I could find an Element using the XKMS searcher method: " + element.getTagName()));
            IdResolver.registerElementById(element, string);
            return element;
        }
        element = IdResolver.getElementByIdUnsafeMatchByIdName(document, string);
        if (element != null) {
            log.warn((Object)("Found an Element using an insecure Id/ID/id search method: " + element.getTagName()));
            return element;
        }
        return null;
    }

    private static Element getElementByIdUsingDOM(Document document, String string) {
        log.debug((Object)("getElementByIdUsingDOM() Search for ID " + string));
        return document.getElementById(string);
    }

    private static Element getElementByIdType(Document document, String string) {
        log.debug((Object)("getElementByIdType() Search for ID " + string));
        WeakHashMap weakHashMap = (WeakHashMap)docMap.get(document);
        if (weakHashMap != null) {
            return (Element)weakHashMap.get(string);
        }
        return null;
    }

    private static Element getElementByIdInDSNamespace(Document document, String string) {
        log.debug((Object)("getElementByIdInDSNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//ds:*[@Id='" + string + "']"), (Node)element);
            return element2;
        }
        catch (TransformerException transformerException) {
            log.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdInXENCNamespace(Document document, String string) {
        log.debug((Object)("getElementByIdInXENCNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "xenc", "http://www.w3.org/2001/04/xmlenc#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//xenc:*[@Id='" + string + "']"), (Node)element);
            return element2;
        }
        catch (TransformerException transformerException) {
            log.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdInSOAPSignatureNamespace(Document document, String string) {
        log.debug((Object)("getElementByIdInSOAPSignatureNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "SOAP-SEC", "http://schemas.xmlsoap.org/soap/security/2000-12");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@SOAP-SEC:id='" + string + "']"), (Node)element);
            return element2;
        }
        catch (TransformerException transformerException) {
            log.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdInXKMSNamespace(Document document, String string) {
        log.debug((Object)("getElementByIdInXKMSNamespace() Search for ID " + string));
        try {
            Element element = XMLUtils.createDSctx(document, "xkms", "http://www.w3.org/2002/03/xkms#");
            String[] stringArray = new String[]{"ID", "OriginalRequestID", "RequestID", "ResponseID"};
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//xkms:*[@" + string2 + "='" + string + "']"), (Node)element);
                if (element2 == null) continue;
                return element2;
            }
            return null;
        }
        catch (TransformerException transformerException) {
            log.fatal((Object)"empty", (Throwable)transformerException);
            return null;
        }
    }

    private static Element getElementByIdUnsafeMatchByIdName(Document document, String string) {
        log.debug((Object)("getElementByIdUnsafeMatchByIdName() Search for ID " + string));
        try {
            Element element = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@Id='" + string + "']"));
            if (element != null) {
                return element;
            }
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@ID='" + string + "']"));
            if (element2 != null) {
                return element2;
            }
            Element element3 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@id='" + string + "']"));
            if (element3 != null) {
                return element3;
            }
        }
        catch (TransformerException transformerException) {
            log.fatal((Object)"empty", (Throwable)transformerException);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

