/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    public static boolean CacheSignedNodes = false;
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$signature$Reference == null ? (class$org$apache$xml$security$signature$Reference = Reference.class$("org.apache.xml.security.signature.Reference")) : class$org$apache$xml$security$signature$Reference).getName());
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    Manifest _manifest = null;
    XMLSignatureInput _transformsInput;
    XMLSignatureInput _transformsOutput;
    static /* synthetic */ Class class$org$apache$xml$security$signature$Reference;

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms, String string3) throws XMLSignatureException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._manifest = manifest;
        this.setURI(string2);
        Element element = XMLUtils.createDSctx(this._doc, "ds");
        if (transforms != null) {
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        Object object = MessageDigestAlgorithm.getInstance(this._doc, string3);
        this._constructionElement.appendChild(((ElementProxy)object).getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        object = XMLUtils.createElementInSignatureSpace(this._doc, "DigestValue");
        this._constructionElement.appendChild((Node)object);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    protected Reference(Document document, String string, String string2, Manifest manifest, String string3) throws XMLSignatureException {
        this(document, string, string2, manifest, null, string3);
    }

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms) throws XMLSignatureException {
        this(document, string, string2, manifest, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    protected Reference(Document document, String string, String string2, Manifest manifest) throws XMLSignatureException {
        this(document, string, string2, manifest, null, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    protected Reference(Element element, String string, Manifest manifest) throws XMLSecurityException {
        super(element, string);
        this._manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (element == null) {
            return null;
        }
        String string = element.getAttributeNS(null, "Algorithm");
        if (string == null) {
            return null;
        }
        return MessageDigestAlgorithm.getInstance(this._doc, string);
    }

    public void setURI(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "URI", string);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Type", string);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean typeIsReferenceToObject() {
        return this.getType() != null && this.getType().equals(OBJECT_URI);
    }

    public boolean typeIsReferenceToManifest() {
        return this.getType() != null && this.getType().equals(MANIFEST_URI);
    }

    private void setDigestValueElement(byte[] byArray) throws XMLSignatureException {
        if (this._state == 0) {
            Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestValue");
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                element.removeChild(nodeList.item(i));
            }
            String string = Base64.encode(byArray);
            Text text = this._doc.createTextNode(string);
            element.appendChild(text);
        }
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            byte[] byArray = this.calculateDigest();
            this.setDigestValueElement(byArray);
        }
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr attr = this._constructionElement.getAttributeNodeNS(null, "URI");
            String string = attr == null ? null : attr.getNodeValue();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, this._baseURI, this._manifest._perManifestResolvers);
            if (resourceResolver == null) {
                Object[] objectArray = new Object[]{string};
                throw new ReferenceNotInitializedException("signature.Verification.Reference.NoInput", objectArray);
            }
            resourceResolver.addProperties(this._manifest._resolverProperties);
            XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, this._baseURI);
            this._transformsInput = new XMLSignatureInput(xMLSignatureInput.getBytes());
            this._transformsInput.setSourceURI(xMLSignatureInput.getSourceURI());
            return xMLSignatureInput;
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new ReferenceNotInitializedException("empty", resourceResolverException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsInput() {
        return this._transformsInput;
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput xMLSignatureInput) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput xMLSignatureInput2 = null;
            if (transforms != null) {
                xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput);
                this._transformsOutput = new XMLSignatureInput(xMLSignatureInput2.getBytes());
                this._transformsOutput.setSourceURI(xMLSignatureInput2.getSourceURI());
            } else {
                xMLSignatureInput2 = xMLSignatureInput;
                this._transformsOutput = this._transformsInput;
            }
            return xMLSignatureInput2;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
        return this.getContentsAfterTransformation(xMLSignatureInput);
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            String string;
            Object object;
            Object object2;
            XMLSignatureInput xMLSignatureInput;
            XMLSignatureInput xMLSignatureInput2 = xMLSignatureInput = this.getContentsBeforeTransformation();
            Transforms transforms = this.getTransforms();
            Transform transform = null;
            if (transforms != null) {
                for (int i = 0; i < transforms.getLength(); ++i) {
                    object2 = transforms.item(i);
                    object = ((Transform)object2).getURI();
                    if (((String)object).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || ((String)object).equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || ((String)object).equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || ((String)object).equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) {
                        transform = object2;
                        break;
                    }
                    xMLSignatureInput2 = ((Transform)object2).performTransform(xMLSignatureInput2);
                }
                xMLSignatureInput2.setSourceURI(xMLSignatureInput.getSourceURI());
            }
            if (transform != null && ((string = transform.getURI()).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) && transform.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                object2 = transform.getChildElementLocalName(0, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
                object = new InclusiveNamespaces((Element)object2, this.getBaseURI());
                String string2 = ((InclusiveNamespaces)object).getInclusiveNamespaces();
            }
            return xMLSignatureInput2;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            ElementProxy elementProxy;
            XMLSignatureInput xMLSignatureInput = this.getNodesetBeforeFirstCanonicalization();
            Set set = new HashSet();
            Transforms transforms = this.getTransforms();
            Transform transform = null;
            if (transforms != null) {
                for (int i = 0; i < transforms.getLength(); ++i) {
                    elementProxy = transforms.item(i);
                    String string = ((Transform)elementProxy).getURI();
                    if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) continue;
                    transform = elementProxy;
                    break;
                }
            }
            if (transform != null) {
                String string = transform.getURI();
                if (transform.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                    elementProxy = new InclusiveNamespaces(transform.getChildElementLocalName(0, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces"), this.getBaseURI());
                    set = InclusiveNamespaces.prefixStr2Set(((InclusiveNamespaces)elementProxy).getInclusiveNamespaces());
                }
            }
            return xMLSignatureInput.getHTMLRepresentation(set);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new XMLSignatureException("empty", invalidTransformException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsOutput() {
        return this._transformsOutput;
    }

    protected void dereferenceURIandPerformTransforms() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
            XMLSignatureInput xMLSignatureInput2 = this.getContentsAfterTransformation(xMLSignatureInput);
            if (!CacheSignedNodes) {
                this._transformsInput = new XMLSignatureInput(xMLSignatureInput.getBytes());
                this._transformsInput.setSourceURI(xMLSignatureInput.getSourceURI());
                this._transformsOutput = new XMLSignatureInput(xMLSignatureInput2.getBytes());
                this._transformsOutput.setSourceURI(xMLSignatureInput2.getSourceURI());
            }
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new ReferenceNotInitializedException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "Transforms");
        if (element != null) {
            Transforms transforms = new Transforms(element, this._baseURI);
            return transforms;
        }
        return null;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            this.dereferenceURIandPerformTransforms();
            byte[] byArray = this.getTransformsOutput().getBytes();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new ReferenceNotInitializedException("empty", invalidCanonicalizerException);
        }
    }

    private byte[] calculateDigest() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            byte[] byArray = this.getReferencedBytes();
            MessageDigestAlgorithm messageDigestAlgorithm = this.getMessageDigestAlgorithm();
            messageDigestAlgorithm.reset();
            messageDigestAlgorithm.update(byArray);
            byte[] byArray2 = messageDigestAlgorithm.digest();
            if (byArray.length < 20) {
                log.debug((Object)new String(byArray));
            } else {
                log.debug((Object)(new String(byArray).substring(0, 20) + " ..."));
            }
            return byArray2;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public byte[] getDigestValue() throws Base64DecodingException, XMLSecurityException {
        Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        if (element == null) {
            Object[] objectArray = new Object[]{"DigestValue", "http://www.w3.org/2000/09/xmldsig#"};
            throw new XMLSecurityException("signature.Verification.NoSignatureElement", objectArray);
        }
        byte[] byArray = Base64.decode(element);
        return byArray;
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] byArray;
        byte[] byArray2 = this.getDigestValue();
        boolean bl = MessageDigestAlgorithm.isEqual(byArray2, byArray = this.calculateDigest());
        if (!bl) {
            log.warn((Object)("Verification failed for URI \"" + this.getURI() + "\""));
        } else {
            log.info((Object)("Verification successful for URI \"" + this.getURI() + "\""));
        }
        return bl;
    }

    public String getBaseLocalName() {
        return "Reference";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

