/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver == null ? (class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver = X509SubjectNameResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.X509SubjectNameResolver")) : class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver).getName());
    private NodeList _x509childNodes = null;
    private XMLX509SubjectName[] _x509childObject = null;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "X509Data");
        }
        catch (XMLSignatureException xMLSignatureException) {
            log.debug((Object)"I can't");
            return false;
        }
        try {
            Element element2 = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
            this._x509childNodes = XPathAPI.selectNodeList((Node)element, (String)"./ds:X509SubjectName", (Node)element2);
            if (this._x509childNodes != null && this._x509childNodes.getLength() > 0) {
                log.debug((Object)"Yes Sir, I can");
                return true;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        log.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            int n;
            if (this._x509childNodes == null && ((n = this.engineCanResolve(element, string, storageResolver)) == 0 || this._x509childNodes == null)) {
                return null;
            }
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SubjectName"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.info((Object)"", (Throwable)keyResolverException);
                throw keyResolverException;
            }
            this._x509childObject = new XMLX509SubjectName[this._x509childNodes.getLength()];
            for (n = 0; n < this._x509childNodes.getLength(); ++n) {
                this._x509childObject[n] = new XMLX509SubjectName((Element)this._x509childNodes.item(n), string);
            }
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509SubjectName xMLX509SubjectName = new XMLX509SubjectName(element.getOwnerDocument(), x509Certificate);
                log.debug((Object)("Found Certificate SN: " + xMLX509SubjectName.getSubjectName()));
                for (int i = 0; i < this._x509childObject.length; ++i) {
                    log.debug((Object)("Found Element SN:     " + this._x509childObject[i].getSubjectName()));
                    if (xMLX509SubjectName.equals(this._x509childObject[i])) {
                        log.debug((Object)"match !!! ");
                        return x509Certificate;
                    }
                    log.debug((Object)"no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

