/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JCEMapper {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$algorithms$JCEMapper == null ? (class$org$apache$xml$security$algorithms$JCEMapper = JCEMapper.class$("org.apache.xml.security.algorithms.JCEMapper")) : class$org$apache$xml$security$algorithms$JCEMapper).getName());
    private static Element _providerList = null;
    private static Element _nscontext = null;
    private static Map uriToProvider = new HashMap();
    private static Map cacheProviderIsInClassPath = new HashMap();
    public static final String KEYTYPE_SYMMETRIC_KEY_WRAP = "SymmetricKeyWrap";
    public static final String KEYTYPE_BLOCK_ENCRYPTION = "BlockEncryption";
    public static final String KEYTYPE_KEY_TRANSPORT = "KeyTransport";
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$JCEMapper;

    public static void init(Element element) throws Exception {
        _providerList = element;
        Document document = element.getOwnerDocument();
        _nscontext = XMLUtils.createDSctx(document, "x", "http://www.xmlsecurity.org/NS/#configuration");
    }

    public static boolean addProvider(String string) {
        try {
            if (Security.getProvider(string) == null) {
                Element element = (Element)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Providers/x:Provider[@Id='" + string + "']"), (Node)_nscontext);
                String string2 = element.getAttributeNS(null, "Class");
                Provider provider = (Provider)Class.forName(string2).newInstance();
                if (Security.getProvider(string) == null) {
                    log.debug((Object)("The provider " + string + " had to be added to the java.security.Security"));
                    Security.addProvider(provider);
                    Provider provider2 = Security.getProvider(string);
                    if (provider2 != null) {
                        return true;
                    }
                }
            }
        }
        catch (TransformerException transformerException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return false;
    }

    public static boolean getProviderIsInClassPath(String string) {
        boolean bl = false;
        Boolean bl2 = (Boolean)cacheProviderIsInClassPath.get(string);
        if (bl2 != null && bl2.booleanValue()) {
            return true;
        }
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)_providerList, (String)("./x:Providers/x:Provider[@Id='" + string + "']"), (Node)_nscontext);
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string2 = element.getAttributeNS(null, "Class");
                try {
                    Provider provider = (Provider)Class.forName(string2).newInstance();
                    if (provider == null) continue;
                    bl = true;
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        cacheProviderIsInClassPath.put(string, new Boolean(bl));
        return bl;
    }

    public static boolean getProviderIsRegisteredAtSecurity(String string) {
        Provider provider = Security.getProvider(string);
        return provider != null;
    }

    public static ProviderIdClass translateURItoJCEID(String string) {
        log.debug((Object)("Request for URI " + string));
        ProviderIdClass providerIdClass = (ProviderIdClass)uriToProvider.get(string);
        if (providerIdClass != null) {
            return providerIdClass;
        }
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + string + "']/x:ProviderAlgo"), (Node)_nscontext);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string2 = element.getAttributeNS(null, "JCEName");
                String string3 = element.getAttributeNS(null, "ProviderId");
                if (!JCEMapper.getProviderIsInClassPath(string3)) continue;
                JCEMapper.addProvider(string3);
                ProviderIdClass providerIdClass2 = new ProviderIdClass(string2, string3);
                log.debug((Object)("Found " + providerIdClass2.getAlgorithmID() + " from provider " + providerIdClass2.getProviderId()));
                uriToProvider.put(string, providerIdClass2);
                return providerIdClass2;
            }
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
        }
        return null;
    }

    public static ProviderIdClass translateURItoJCEID(String string, String string2) {
        log.debug((Object)("Request for URI " + string + " from provider " + string2));
        if (!JCEMapper.getProviderIsInClassPath(string2)) {
            return null;
        }
        try {
            Element element = (Element)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + string + "']/x:ProviderAlgo[@ProviderId='" + string2 + "']"), (Node)_nscontext);
            String string3 = element.getAttributeNS(null, "JCEName");
            JCEMapper.addProvider(string2);
            ProviderIdClass providerIdClass = new ProviderIdClass(string3, string2);
            log.debug((Object)("Found " + providerIdClass.getAlgorithmID() + " from provider " + providerIdClass.getProviderId()));
            return providerIdClass;
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
            return null;
        }
    }

    public static String getAlgorithmClassFromURI(String string) {
        log.debug((Object)("Request for URI " + string));
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + string + "']/x:ProviderAlgo"), (Node)_nscontext);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                Attr attr = element.getAttributeNodeNS(null, "JCEName");
                log.debug((Object)("Found " + attr.getNodeValue()));
            }
            return ((Element)nodeList.item(0)).getAttributeNS(null, "JCEName");
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
            return "";
        }
    }

    public static int getKeyTypeFromURI(String string) {
        try {
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + string + "']/@AlgorithmClass"), (Node)_nscontext);
            if (attr == null) {
                return -1;
            }
            String string2 = attr.getNodeValue();
            if (string2.equals(KEYTYPE_BLOCK_ENCRYPTION)) {
                return 3;
            }
            if (string2.equals("Mac")) {
                return 3;
            }
            if (string2.equals(KEYTYPE_SYMMETRIC_KEY_WRAP)) {
                return 3;
            }
            if (string2.equals(KEYTYPE_KEY_TRANSPORT)) {
                return 3;
            }
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
        }
        return -1;
    }

    public static int getKeyLengthFromURI(String string) {
        try {
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + string + "']/@KeyLength"), (Node)_nscontext);
            if (attr != null) {
                return Integer.parseInt(attr.getNodeValue());
            }
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
        }
        return 0;
    }

    public static String getJCEKeyAlgorithmFromURI(String string, String string2) {
        try {
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + string + "']/x:ProviderAlgo[@ProviderId='" + string2 + "']/@RequiredKey"), (Node)_nscontext);
            if (attr != null) {
                return attr.getNodeValue();
            }
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
        }
        return null;
    }

    public static String getJCEIVAlgorithmFromURI(String string, String string2) {
        try {
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + string + "']/x:ProviderAlgo[@ProviderId='" + string2 + "']/@IVJCEName"), (Node)_nscontext);
            if (attr != null) {
                return attr.getNodeValue();
            }
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
        }
        return null;
    }

    public static String getURIfromKey(Key key, String string) {
        String string2 = key.getAlgorithm();
        String string3 = new Integer(key.getEncoded().length * 8).toString();
        try {
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@KeyLength='" + string3 + "' and @AlgorithmClass='" + string + "']/x:ProviderAlgo[@RequiredKey='" + string2 + "']/../@URI"), (Node)_nscontext);
            if (attr != null) {
                return attr.getNodeValue();
            }
        }
        catch (TransformerException transformerException) {
            log.debug((Object)("Found nothing: " + transformerException.getMessage()));
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ProviderIdClass {
        private String _algorithmId;
        private String _providerId;

        protected ProviderIdClass(String string, String string2) {
            this._algorithmId = string;
            this._providerId = string2;
        }

        public String getAlgorithmID() {
            return this._algorithmId;
        }

        public String getProviderId() {
            return this._providerId;
        }
    }
}

