/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ElementProxy {
    static Category cat;
    public static final int MODE_CREATE = 0;
    public static final int MODE_PROCESS = 1;
    public static final int MODE_UNKNOWN = 2;
    public static final int MODE_SIGN = 0;
    public static final int MODE_VERIFY = 1;
    public static final int MODE_ENCRYPT = 0;
    public static final int MODE_DECRYPT = 1;
    static HashMap _prefixMappings;
    protected int _state;
    protected Element _constructionElement;
    protected String _baseURI;
    protected Document _doc;
    static /* synthetic */ Class class$org$apache$xml$security$utils$ElementProxy;

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    public static Element createElementForFamily(Document document, String string, String string2) {
        Element element = null;
        String string3 = ElementProxy.getDefaultPrefix(string);
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else if (string3 == null || string3.length() == 0) {
            element = document.createElementNS(string, string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
        } else {
            element = document.createElementNS(string, string3 + ':' + string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, string);
        }
        return element;
    }

    public void setElement(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        cat.debug((Object)("setElement(" + element.getTagName() + ", \"" + string + '\"'));
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = string;
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        helperNodeList.appendChild(this.getElement());
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        return helperNodeList;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    public void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        String string = this.getBaseLocalName();
        String string2 = this.getBaseNamespace();
        String string3 = "{" + (string2 == null ? "" : string2) + '}' + string;
        String string4 = this._constructionElement.getLocalName();
        String string5 = this._constructionElement.getNamespaceURI();
        String string6 = "{" + (string5 == null ? "" : string5) + '}' + string4;
        if (!string6.equals(string3)) {
            Object[] objectArray = new Object[]{string3, string6};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
    }

    public void addBigIntegerElement(BigInteger bigInteger, String string) {
        if (bigInteger != null) {
            Element element = XMLUtils.createElementInSignatureSpace(this._doc, string);
            Base64.fillElementWithBigInteger(element, bigInteger);
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] byArray, String string) {
        if (byArray != null) {
            Element element = Base64.encodeToElement(this._doc, string, byArray);
            this._constructionElement.appendChild(element);
            this._constructionElement.appendChild(this._doc.createTextNode("\n"));
        }
    }

    public void addTextElement(String string, String string2) {
        Element element = XMLUtils.createElementInSignatureSpace(this._doc, string2);
        Text text = this._doc.createTextNode(string);
        element.appendChild(text);
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] byArray) {
        if (byArray != null) {
            Text text = this._doc.createTextNode("\n" + Base64.encode(byArray) + '\n');
            this._constructionElement.appendChild(text);
        }
    }

    public void addText(String string) {
        if (string != null) {
            Text text = this._doc.createTextNode(string);
            this._constructionElement.appendChild(text);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String string, String string2) throws XMLSecurityException {
        try {
            Element element = XMLUtils.createDSctx(this._doc, "x", string2);
            Text text = (Text)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./x:" + string + "/text()"), (Node)element);
            return Base64.decodeBigIntegerFromText(text);
        }
        catch (TransformerException transformerException) {
            throw new XMLSecurityException("empty", transformerException);
        }
    }

    public byte[] getBytesFromChildElement(String string, String string2) throws XMLSecurityException {
        try {
            Element element = XMLUtils.createDSctx(this._doc, "x", string2);
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./x:" + string), (Node)element);
            return Base64.decode(element2);
        }
        catch (TransformerException transformerException) {
            throw new XMLSecurityException("empty", transformerException);
        }
    }

    public String getTextFromChildElement(String string, String string2) throws XMLSecurityException {
        try {
            Element element = XMLUtils.createDSctx(this._doc, "x", string2);
            Text text = (Text)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./x:" + string + "/text()"), (Node)element);
            return text.getData();
        }
        catch (TransformerException transformerException) {
            throw new XMLSecurityException("empty", transformerException);
        }
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        try {
            Text text = (Text)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)"./text()");
            return Base64.decode(text.getData());
        }
        catch (TransformerException transformerException) {
            throw new XMLSecurityException("empty", transformerException);
        }
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this._constructionElement);
    }

    public Element getChildElementLocalName(int n, String string, String string2) {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            Node node = nodeList.item(n4);
            if (node.getNodeType() == 1) {
                String string3 = node.getNamespaceURI();
                String string4 = node.getLocalName();
                if ((string != null && string3 != null && string.equals(string3) || string == null && string3 == null) && string2.equals(string4) && ++n3 == n) {
                    return (Element)node;
                }
            }
            ++n4;
        }
        return null;
    }

    public int length(String string, String string2) {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1) {
                String string3 = node.getNamespaceURI();
                String string4 = node.getLocalName();
                if ((string != null && string3 != null && string.equals(string3) || string == null && string3 == null) && string2.equals(string4)) {
                    ++n2;
                }
            }
            ++n3;
        }
        return n2;
    }

    public void setXPathNamespaceContext(String string, String string2) throws XMLSecurityException {
        String string3 = string == null || string.length() == 0 ? "xmlns" : (string.equals("xmlns") ? "xmlns" : (string.startsWith("xmlns:") ? "xmlns:" + string.substring("xmlns:".length()) : "xmlns:" + string));
        if (string3.equals("xmlns")) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        Attr attr = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string3);
        if (attr != null && !attr.getNodeValue().equals(string2)) {
            Object[] objectArray = new Object[]{string3, this._constructionElement.getAttributeNS(null, string3)};
            throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", objectArray);
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    public static void setDefaultPrefix(String string, String string2) throws XMLSecurityException {
        Iterator iterator = _prefixMappings.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = (String)_prefixMappings.get(string3);
            if (!string4.equals(string2) || string3.equals(string)) continue;
            Object[] objectArray = new Object[]{string2, string, string3};
            throw new XMLSecurityException("prefix.AlreadyAssigned", objectArray);
        }
        _prefixMappings.put(string, string2);
    }

    public static String getDefaultPrefix(String string) {
        String string2 = (String)_prefixMappings.get(string);
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this._state = 2;
        this._constructionElement = null;
        this._baseURI = null;
        this._doc = null;
    }

    public ElementProxy() {
        this.this();
        this._doc = null;
        this._state = 2;
        this._baseURI = null;
        this._constructionElement = null;
    }

    public ElementProxy(Document document) {
        this();
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = document;
        this._state = 0;
        this._constructionElement = ElementProxy.createElementForFamily(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    public ElementProxy(Element element, String string) throws XMLSecurityException {
        this();
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        cat.debug((Object)("setElement(\"" + element.getTagName() + "\", \"" + string + "\")"));
        this._doc = element.getOwnerDocument();
        this._state = 1;
        this._constructionElement = element;
        this._baseURI = string;
        this.guaranteeThatElementInCorrectSpace();
    }

    static {
        Class clazz = class$org$apache$xml$security$utils$ElementProxy;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$utils$ElementProxy = ElementProxy.class$("org.apache.xml.security.utils.ElementProxy");
        }
        cat = Category.getInstance((String)clazz.getName());
        _prefixMappings = new HashMap();
    }
}

