/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";
    private static final String FUnion = "union";
    private static final String FSubtract = "subtract";
    private static final String FIntersect = "intersect";
    Vector _filterTypes;
    Vector _filterNodes;
    Set _F;
    Vector _ancestors;
    Set _inputSet;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return false;
    }

    public boolean returnsNodeSet() {
        return true;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            Object object;
            long l = System.currentTimeMillis();
            this._inputSet = xMLSignatureInput.getNodeSet();
            if (this._inputSet.size() == 0) {
                return xMLSignatureInput;
            }
            CachedXPathFuncHereAPI cachedXPathFuncHereAPI = new CachedXPathFuncHereAPI(xMLSignatureInput.getCachedXPathAPI());
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI(xMLSignatureInput.getCachedXPathAPI());
            Document document = null;
            Iterator iterator = this._inputSet.iterator();
            document = XMLUtils.getOwnerDocument((Node)iterator.next());
            int n = this._transformObject.length(implementedTransformURI, "XPath");
            if (n == 0) {
                Object[] objectArray = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            XPath2FilterContainer xPath2FilterContainer = XPath2FilterContainer.newInstanceUnion(this._transformObject.getDocument(), "/");
            this._filterTypes.add(FUnion);
            Object object2 = new HelperNodeList();
            ((HelperNodeList)object2).appendChild(document);
            this._filterNodes.add(object2);
            int n2 = 0;
            while (n2 < n) {
                object2 = this._transformObject.getChildElementLocalName(n2, implementedTransformURI, "XPath");
                object = XPath2FilterContainer.newInstance((Element)object2, xMLSignatureInput.getSourceURI());
                if (((XPath2FilterContainer)object).isIntersect()) {
                    this._filterTypes.add(FIntersect);
                } else if (((XPath2FilterContainer)object).isSubtract()) {
                    this._filterTypes.add(FSubtract);
                } else if (((XPath2FilterContainer)object).isUnion()) {
                    this._filterTypes.add(FUnion);
                } else {
                    this._filterTypes.add(null);
                }
                NodeList nodeList = cachedXPathFuncHereAPI.selectNodeList(document, ((XPath2FilterContainer)object).getXPathFilterTextNode(), ((ElementProxy)object).getElement());
                this._filterNodes.add(nodeList);
                ++n2;
            }
            this._F = new HashSet();
            this._ancestors = new Vector();
            this.traversal(document);
            HashSet<Object> hashSet = new HashSet<Object>();
            object2 = this._inputSet.iterator();
            while (object2.hasNext()) {
                object = (Node)object2.next();
                if (!this._F.contains(object)) continue;
                hashSet.add(object);
            }
            object = new XMLSignatureInput(hashSet, xMLSignatureInput.getCachedXPathAPI());
            ((XMLSignatureInput)object).setSourceURI(xMLSignatureInput.getSourceURI());
            long l2 = System.currentTimeMillis();
            return object;
        }
        catch (TransformerException transformerException) {
            throw new TransformationException("empty", transformerException);
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("empty", parserConfigurationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("empty", sAXException);
        }
    }

    private final void traversal(Node node) {
        int n;
        int n2;
        this._ancestors.add(node);
        if (this._inputSet.contains(node)) {
            int n3 = this._filterTypes.size();
            n2 = 0;
            n2 = n3 - 1;
            while (n2 >= 0) {
                NodeList nodeList = (NodeList)this._filterNodes.elementAt(n2);
                String string = (String)this._filterTypes.elementAt(n2);
                if (string == FUnion && this.rooted(node, this._ancestors, nodeList)) break;
                --n2;
            }
            n = n2;
            if (n == -1) {
                n = 0;
            }
            boolean bl = true;
            int n4 = n;
            while (n4 < n3) {
                NodeList nodeList = (NodeList)this._filterNodes.elementAt(n4);
                String string = (String)this._filterTypes.elementAt(n4);
                boolean bl2 = this.rooted(node, this._ancestors, nodeList);
                if (string == FIntersect && !bl2) {
                    bl = false;
                    break;
                }
                if (string == FSubtract && bl2) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                this._F.add(node);
            }
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
            n2 = namedNodeMap.getLength();
            n = 0;
            while (n < n2) {
                Node node2 = namedNodeMap.item(n);
                this.traversal(node2);
                ++n;
            }
        }
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            this.traversal(node3);
            node3 = node3.getNextSibling();
        }
        this._ancestors.remove(node);
    }

    boolean rooted(Node node, Vector vector, NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (vector.contains(node2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final boolean __isRootedBy(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        if (node2.getNodeType() == 9) {
            return true;
        }
        Node node3 = node;
        while (node3 != null) {
            if (node3 == node2) {
                return true;
            }
            node3 = node3.getNodeType() == 2 ? ((Attr)node3).getOwnerElement() : node3.getParentNode();
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this._filterTypes = new Vector();
        this._filterNodes = new Vector();
        this._F = null;
        this._ancestors = null;
        this._inputSet = null;
    }

    public TransformXPath2Filter() {
        this.this();
    }
}

