/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.provider;

import java.security.DigestException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.provider.KeyBaseType;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyElement
extends KeyBaseType {
    public static final byte[] salt = new byte[]{-55, 54, 120, -103, 82, 62, -22, -14};

    private final void wrap(byte[] byArray) {
    }

    private final void wrap(Key key, char[] cArray) {
        try {
            Key key2 = KeyElement.createWrapKey("http://www.w3.org/2001/04/xmlenc#kw-aes256", cArray);
            EncryptedKey encryptedKey = new EncryptedKey(this._doc, "http://www.w3.org/2001/04/xmlenc#kw-aes256", null, null, key, key2, null, null, null, null, null, null);
            this._constructionElement.appendChild(encryptedKey.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new RuntimeException(xMLSecurityException.getMessage());
        }
    }

    public Key unwrap(char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            Key key = KeyElement.createWrapKey("http://www.w3.org/2001/04/xmlenc#kw-aes256", cArray);
            EncryptedKey encryptedKey = new EncryptedKey(this.getChildElementLocalName(0, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"), this._baseURI);
            return encryptedKey.unwrap(key, "http://www.w3.org/2001/04/xmlenc#kw-aes128");
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new RuntimeException(xMLSecurityException.getMessage());
        }
    }

    public String getBaseLocalName() {
        return "Key";
    }

    public void setCertificateChain(Certificate[] certificateArray) throws XMLSecurityException {
        if (this._state == 0 && certificateArray != null && certificateArray.length > 0) {
            Element element = ElementProxy.createElementForFamily(this._doc, this.getBaseNamespace(), "CertificateChain");
            XMLUtils.addReturnToElement(element);
            int n = 0;
            while (n < certificateArray.length) {
                Certificate certificate = certificateArray[n];
                if (certificate != null) {
                    if (certificate.getType().equals("X.509")) {
                        X509Data x509Data = new X509Data(this._doc);
                        x509Data.add(new XMLX509Certificate(this._doc, (X509Certificate)certificate));
                        element.appendChild(x509Data.getElement());
                        XMLUtils.addReturnToElement(element);
                    } else {
                        throw new IllegalArgumentException("The certificate " + n + " is of type " + certificate.getType() + ", but I can only handle X.509 certificates");
                    }
                }
                ++n;
            }
            this._constructionElement.appendChild(element);
        }
    }

    public Certificate[] getCertificateChain(String string) {
        try {
            NodeList nodeList = this._constructionElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            Certificate[] certificateArray = new Certificate[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element = (Element)nodeList.item(n);
                XMLX509Certificate xMLX509Certificate = new XMLX509Certificate(element, this._baseURI);
                certificateArray[n] = xMLX509Certificate.getX509Certificate();
                ++n;
            }
            return certificateArray;
        }
        catch (XMLSecurityException xMLSecurityException) {
            return new Certificate[0];
        }
    }

    public static byte[] PKCS12PasswordToBytes(char[] cArray) {
        byte[] byArray = new byte[(cArray.length + 1) * 2];
        int n = 0;
        while (n != cArray.length) {
            byArray[n * 2] = (byte)(cArray[n] >>> 8);
            byArray[n * 2 + 1] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    private static final Key createWrapKey(String string, char[] cArray) throws XMLSecurityException {
        int n = JCEMapper.getKeyLengthFromURI(string) / 8;
        String string2 = JCEMapper.getJCEKeyAlgorithmFromURI(string, "BC");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", "BC");
            messageDigest.update(KeyElement.PKCS12PasswordToBytes(cArray));
            byte[] byArray = new byte[n];
            messageDigest.digest(byArray, 0, byArray.length);
            return new SecretKeySpec(byArray, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (DigestException digestException) {
            // empty catch block
        }
        return null;
    }

    public KeyElement(Document document, String string, Key key, char[] cArray, Certificate[] certificateArray) throws XMLSecurityException {
        super(document, string);
        this.wrap(key, cArray);
        this.setCertificateChain(certificateArray);
    }

    public KeyElement(Document document, String string, byte[] byArray, Certificate[] certificateArray) throws XMLSecurityException {
        super(document, string);
        this.wrap(byArray);
        this.setCertificateChain(certificateArray);
    }

    public KeyElement(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }
}

