/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import org.apache.xml.security.encryption.CipherReference;
import org.apache.xml.security.encryption.CipherValue;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.EncryptionElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CipherData
extends EncryptionElementProxy {
    public CipherValue getCipherValue() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        if (element == null) {
            return null;
        }
        return new CipherValue(element, this._baseURI);
    }

    public CipherReference getCipherReference() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "CipherReference", "http://www.w3.org/2001/04/xmlenc#");
        if (element == null) {
            return null;
        }
        return new CipherReference(element, this._baseURI);
    }

    public boolean isCipherValue() {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        return element != null;
    }

    public boolean isCipherReference() {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "CipherReference", "http://www.w3.org/2001/04/xmlenc#");
        return element != null;
    }

    public boolean isNotYetFilled() {
        boolean bl = false;
        if (!this.isCipherReference() && !this.isCipherValue()) {
            bl = true;
        }
        return bl;
    }

    public void setCipherValue(CipherValue cipherValue) throws XMLSecurityException {
        if (this.isNotYetFilled()) {
            this._constructionElement.appendChild(cipherValue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void setCipherReference(CipherReference cipherReference) throws XMLSecurityException {
        if (this.isNotYetFilled()) {
            this._constructionElement.appendChild(cipherReference.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public String getBaseLocalName() {
        return "CipherData";
    }

    public CipherData(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public CipherData(Document document, CipherValue cipherValue) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(cipherValue.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public CipherData(Document document, CipherReference cipherReference) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(cipherReference.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public CipherData(Document document, byte[] byArray) throws XMLSecurityException {
        this(document, new CipherValue(document, byArray));
    }

    public CipherData(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }
}

