/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.params;

import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OAEPParams
extends EncryptionMethodParams {
    public static final String DEFAULT_DIGEST = "http://www.w3.org/2000/09/xmldsig#sha1";
    String _digestMethodURI;
    byte[] _OAEPParamBytes;

    public String getAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    public String getDigestMethodURI() {
        return this._digestMethodURI;
    }

    public byte[] getOAEPParamBytes() {
        return this._OAEPParamBytes;
    }

    public DocumentFragment createChildNodes(Document document) throws XMLSecurityException {
        DocumentFragment documentFragment = document.createDocumentFragment();
        XMLUtils.addReturnToNode(documentFragment);
        MessageDigestAlgorithm messageDigestAlgorithm = MessageDigestAlgorithm.getInstance(document, this.getDigestMethodURI());
        documentFragment.appendChild(messageDigestAlgorithm.getElement());
        XMLUtils.addReturnToNode(documentFragment);
        if (this.getOAEPParamBytes() != null && this.getOAEPParamBytes().length > 0) {
            Element element = XMLUtils.createElementInEncryptionSpace(document, "OAEPparams");
            if (this.getOAEPParamBytes() != null) {
                Text text = document.createTextNode(Base64.encode(this.getOAEPParamBytes()));
                element.appendChild(text);
            }
            documentFragment.appendChild(element);
            XMLUtils.addReturnToNode(documentFragment);
        }
        return documentFragment;
    }

    public OAEPParams(String string, byte[] byArray) {
        this._digestMethodURI = string == null ? DEFAULT_DIGEST : string;
        this._OAEPParamBytes = (byte[])(byArray == null || byArray.length == 0 ? null : byArray);
    }

    public OAEPParams(Element element) throws XMLSecurityException {
        Element element2 = XMLUtils.getDirectChild(element, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#");
        Element element3 = XMLUtils.getDirectChild(element, "OAEPparams", "http://www.w3.org/2001/04/xmlenc#");
        if (element2 == null) {
            throw new XMLSecurityException("encryption.MissingDigestMethod");
        }
        if (element3 == null) {
            throw new XMLSecurityException("encryption.MissingOAEPParams");
        }
        this._digestMethodURI = element2.getAttributeNS(null, "Algorithm");
        this._OAEPParamBytes = Base64.decode(element3);
    }
}

