/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import xin.dlong.ocr.ui.R;
import xin.dlong.ocr.ui.camera.Camera1Control;
import xin.dlong.ocr.ui.camera.CameraThreadPool;
import xin.dlong.ocr.ui.camera.ICameraControl;
import xin.dlong.ocr.ui.camera.MaskView;
import xin.dlong.ocr.ui.util.DimensionUtil;
import xin.dlong.ocr.ui.util.ImageUtil;

public class CameraView
extends FrameLayout {
    private int maskType;
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_HORIZONTAL = 90;
    public static final int ORIENTATION_INVERT = 270;
    public static final int NATIVE_AUTH_INIT_SUCCESS = 0;
    public static final int NATIVE_SOLOAD_FAIL = 10;
    public static final int NATIVE_AUTH_FAIL = 11;
    public static final int NATIVE_INIT_FAIL = 12;
    private int initNativeStatus = 0;
    private CameraViewTakePictureCallback cameraViewTakePictureCallback = new CameraViewTakePictureCallback();
    private ICameraControl cameraControl;
    private View displayView;
    private MaskView maskView;
    private ImageView hintView;
    private TextView hintViewText;
    private LinearLayout hintViewTextWrapper;
    Handler uiHandler = new Handler(Looper.getMainLooper());
    private OnTakePictureCallback autoPictureCallback;

    public ICameraControl getCameraControl() {
        return this.cameraControl;
    }

    public void setOrientation(@Orientation int orientation) {
        this.cameraControl.setDisplayOrientation(orientation);
    }

    public CameraView(Context context) {
        super(context);
        this.init();
    }

    public CameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void start() {
        this.cameraControl.start();
        this.setKeepScreenOn(true);
    }

    public void stop() {
        this.cameraControl.stop();
        this.setKeepScreenOn(false);
    }

    public void takePicture(File file, OnTakePictureCallback callback) {
        this.cameraViewTakePictureCallback.file = file;
        this.cameraViewTakePictureCallback.callback = callback;
        this.cameraControl.takePicture(this.cameraViewTakePictureCallback);
    }

    public void setAutoPictureCallback(OnTakePictureCallback callback) {
        this.autoPictureCallback = callback;
    }

    public void setMaskType(@MaskView.MaskType int maskType, Context ctx) {
        this.maskView.setMaskType(maskType);
        this.maskView.setVisibility(0);
        this.hintView.setVisibility(0);
        int hintResourceId = R.drawable.bd_ocr_hint_align_id_card;
        this.maskType = maskType;
        boolean isNeedSetImage = true;
        switch (maskType) {
            case 1: {
                hintResourceId = R.drawable.bd_ocr_round_corner;
                isNeedSetImage = false;
                break;
            }
            case 2: {
                isNeedSetImage = false;
                hintResourceId = R.drawable.bd_ocr_round_corner;
                break;
            }
            case 11: {
                hintResourceId = R.drawable.bd_ocr_hint_align_bank_card;
                break;
            }
            default: {
                this.maskView.setVisibility(4);
                this.hintView.setVisibility(4);
            }
        }
        if (isNeedSetImage) {
            this.hintView.setImageResource(hintResourceId);
            this.hintViewTextWrapper.setVisibility(4);
        }
    }

    private String getScanMessage(int status) {
        String message;
        switch (status) {
            case 0: {
                message = "";
                break;
            }
            case 2: {
                message = "\u8eab\u4efd\u8bc1\u6a21\u7cca\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5";
                break;
            }
            case 3: {
                message = "\u8eab\u4efd\u8bc1\u53cd\u5149\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5";
                break;
            }
            case 4: {
                message = "\u8bf7\u5c06\u8eab\u4efd\u8bc1\u524d\u540e\u53cd\u8f6c\u518d\u8fdb\u884c\u8bc6\u522b";
                break;
            }
            case 5: {
                message = "\u8bf7\u62ff\u7a33\u955c\u5934\u548c\u8eab\u4efd\u8bc1";
                break;
            }
            case 6: {
                message = "\u8bf7\u5c06\u955c\u5934\u9760\u8fd1\u8eab\u4efd\u8bc1";
                break;
            }
            case 7: {
                message = "\u8bf7\u786e\u4fdd\u8eab\u4efd\u8bc1\u5b8c\u6574";
                break;
            }
            case 11: {
                message = "\u672c\u5730\u8d28\u91cf\u63a7\u5236\u6388\u6743\u5931\u8d25";
                break;
            }
            case 12: {
                message = "\u672c\u5730\u6a21\u578b\u52a0\u8f7d\u5931\u8d25";
                break;
            }
            case 10: {
                message = "\u672c\u5730SO\u5e93\u52a0\u8f7d\u5931\u8d25";
                break;
            }
            default: {
                message = "\u8bf7\u5c06\u8eab\u4efd\u8bc1\u7f6e\u4e8e\u53d6\u666f\u6846\u5185";
            }
        }
        return message;
    }

    private void init() {
        this.cameraControl = new Camera1Control(this.getContext());
        this.displayView = this.cameraControl.getDisplayView();
        this.addView(this.displayView);
        this.maskView = new MaskView(this.getContext());
        this.addView(this.maskView);
        this.hintView = new ImageView(this.getContext());
        this.addView((View)this.hintView);
        this.hintViewTextWrapper = new LinearLayout(this.getContext());
        this.hintViewTextWrapper.setOrientation(1);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, DimensionUtil.dpToPx(25));
        lp.gravity = 17;
        this.hintViewText = new TextView(this.getContext());
        this.hintViewText.setBackgroundResource(R.drawable.bd_ocr_round_corner);
        this.hintViewText.setAlpha(0.5f);
        this.hintViewText.setPadding(DimensionUtil.dpToPx(10), 0, DimensionUtil.dpToPx(10), 0);
        this.hintViewTextWrapper.addView((View)this.hintViewText, (ViewGroup.LayoutParams)lp);
        this.hintViewText.setGravity(17);
        this.hintViewText.setTextColor(-1);
        this.hintViewText.setTextSize(2, 14.0f);
        this.hintViewText.setText((CharSequence)this.getScanMessage(-1));
        this.addView((View)this.hintViewTextWrapper, (ViewGroup.LayoutParams)lp);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.displayView.layout(left, 0, right, bottom - top);
        this.maskView.layout(left, 0, right, bottom - top);
        int hintViewWidth = DimensionUtil.dpToPx(250);
        int hintViewHeight = DimensionUtil.dpToPx(25);
        int hintViewLeft = (this.getWidth() - hintViewWidth) / 2;
        int hintViewTop = this.maskView.getFrameRect().bottom + DimensionUtil.dpToPx(16);
        this.hintViewTextWrapper.layout(hintViewLeft, hintViewTop, hintViewLeft + hintViewWidth, hintViewTop + hintViewHeight);
        this.hintView.layout(hintViewLeft, hintViewTop, hintViewLeft + hintViewWidth, hintViewTop + hintViewHeight);
    }

    private Bitmap crop(File outputFile, byte[] data, int rotation) {
        try {
            BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((byte[])data, (int)0, (int)data.length, (boolean)true);
            Rect previewFrame = this.cameraControl.getPreviewFrame();
            int width = rotation % 180 == 0 ? decoder.getWidth() : decoder.getHeight();
            int height = rotation % 180 == 0 ? decoder.getHeight() : decoder.getWidth();
            Rect frameRect = this.maskView.getFrameRect();
            int left = width * frameRect.left / this.maskView.getWidth();
            int top = height * frameRect.top / this.maskView.getHeight();
            int right = width * frameRect.right / this.maskView.getWidth();
            int bottom = height * frameRect.bottom / this.maskView.getHeight();
            if (previewFrame.top < 0) {
                int adjustedPreviewHeight = previewFrame.height() * this.getWidth() / previewFrame.width();
                int topInFrame = (adjustedPreviewHeight - frameRect.height()) / 2 * this.getWidth() / previewFrame.width();
                int bottomInFrame = (adjustedPreviewHeight + frameRect.height()) / 2 * this.getWidth() / previewFrame.width();
                top = topInFrame * height / previewFrame.height();
                bottom = bottomInFrame * height / previewFrame.height();
            } else if (previewFrame.left < 0) {
                int adjustedPreviewWidth = previewFrame.width() * this.getHeight() / previewFrame.height();
                int leftInFrame = (adjustedPreviewWidth - this.maskView.getFrameRect().width()) / 2 * this.getHeight() / previewFrame.height();
                int rightInFrame = (adjustedPreviewWidth + this.maskView.getFrameRect().width()) / 2 * this.getHeight() / previewFrame.height();
                left = leftInFrame * width / previewFrame.width();
                right = rightInFrame * width / previewFrame.width();
            }
            Rect region = new Rect();
            region.left = left;
            region.top = top;
            region.right = right;
            region.bottom = bottom;
            if (rotation % 180 == 90) {
                int x = decoder.getWidth() / 2;
                int y = decoder.getHeight() / 2;
                int rotatedWidth = region.height();
                int rotated = region.width();
                region.left = x - rotatedWidth / 2;
                region.top = y - rotated / 2;
                region.right = x + rotatedWidth / 2;
                region.bottom = y + rotated / 2;
                region.sort();
            }
            BitmapFactory.Options options = new BitmapFactory.Options();
            int maxPreviewImageSize = 2560;
            int size = Math.min(decoder.getWidth(), decoder.getHeight());
            size = Math.min(size, maxPreviewImageSize);
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, size, size);
            options.inScaled = true;
            options.inDensity = Math.max(options.outWidth, options.outHeight);
            options.inTargetDensity = size;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            Bitmap bitmap = decoder.decodeRegion(region, options);
            if (rotation != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate((float)rotation);
                Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
                if (bitmap != rotatedBitmap) {
                    bitmap.recycle();
                }
                bitmap = rotatedBitmap;
            }
            try {
                if (!outputFile.exists()) {
                    outputFile.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                fileOutputStream.close();
                return bitmap;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void release() {
    }

    private class CameraViewTakePictureCallback
    implements ICameraControl.OnTakePictureCallback {
        private File file;
        private OnTakePictureCallback callback;

        private CameraViewTakePictureCallback() {
        }

        @Override
        public void onPictureTaken(final byte[] data) {
            CameraThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    int rotation = ImageUtil.getOrientation(data);
                    Bitmap bitmap = CameraView.this.crop(CameraViewTakePictureCallback.this.file, data, rotation);
                    CameraViewTakePictureCallback.this.callback.onPictureTaken(bitmap);
                }
            });
        }
    }

    public static @interface Orientation {
    }

    static interface OnTakePictureCallback {
        public void onPictureTaken(Bitmap var1);
    }
}

