/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.crop;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import xin.dlong.ocr.ui.util.DimensionUtil;

public class FrameOverlayView
extends View {
    private GestureDetector.SimpleOnGestureListener onGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            FrameOverlayView.this.translate(distanceX, distanceY);
            return true;
        }
    };
    private static final int CORNER_LEFT_TOP = 1;
    private static final int CORNER_RIGHT_TOP = 2;
    private static final int CORNER_RIGHT_BOTTOM = 3;
    private static final int CORNER_LEFT_BOTTOM = 4;
    private int currentCorner = -1;
    int margin = 20;
    int cornerLength = 100;
    int cornerLineWidth = 6;
    private int maskColor = Color.argb((int)180, (int)0, (int)0, (int)0);
    private Paint paint = new Paint(1);
    private Paint eraser = new Paint(1);
    private GestureDetector gestureDetector;
    private RectF touchRect = new RectF();
    private RectF frameRect = new RectF();
    private OnFrameChangeListener onFrameChangeListener;
    private int shapeType;

    public Rect getFrameRect() {
        Rect rect = new Rect();
        rect.left = (int)this.frameRect.left;
        rect.top = (int)this.frameRect.top;
        rect.right = (int)this.frameRect.right;
        rect.bottom = (int)this.frameRect.bottom;
        return rect;
    }

    public FrameOverlayView(Context context) {
        super(context);
        this.setLayerType(1, null);
        this.paint.setColor(-1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(6.0f);
        this.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.shapeType = 0;
        this.init();
    }

    public FrameOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, null);
        this.paint.setColor(-1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(6.0f);
        this.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.shapeType = 0;
        this.init();
    }

    public FrameOverlayView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        this.paint.setColor(-1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(6.0f);
        this.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.shapeType = 0;
        this.init();
    }

    public void setOnFrameChangeListener(OnFrameChangeListener onFrameChangeListener) {
        this.onFrameChangeListener = onFrameChangeListener;
    }

    private void init() {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.onGestureListener);
        this.cornerLength = DimensionUtil.dpToPx(18);
        this.cornerLineWidth = DimensionUtil.dpToPx(3);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.resetFrameRect(w, h);
    }

    private void resetFrameRect(int w, int h) {
        if (this.shapeType == 1) {
            this.frameRect.left = (int)((double)w * 0.05);
            this.frameRect.top = (int)((double)h * 0.25);
        } else {
            this.frameRect.left = (int)((double)w * 0.2);
            this.frameRect.top = (int)((double)h * 0.2);
        }
        this.frameRect.right = (float)w - this.frameRect.left;
        this.frameRect.bottom = (float)h - this.frameRect.top;
    }

    public void setTypeWide() {
        this.shapeType = 1;
    }

    private void translate(float x, float y) {
        if (x > 0.0f) {
            if (this.frameRect.left - x < (float)this.margin) {
                x = this.frameRect.left - (float)this.margin;
            }
        } else if (this.frameRect.right - x > (float)(this.getWidth() - this.margin)) {
            x = this.frameRect.right - (float)this.getWidth() + (float)this.margin;
        }
        if (y > 0.0f) {
            if (this.frameRect.top - y < (float)this.margin) {
                y = this.frameRect.top - (float)this.margin;
            }
        } else if (this.frameRect.bottom - y > (float)(this.getHeight() - this.margin)) {
            y = this.frameRect.bottom - (float)this.getHeight() + (float)this.margin;
        }
        this.frameRect.offset(-x, -y);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawColor(this.maskColor);
        this.paint.setStrokeWidth((float)DimensionUtil.dpToPx(1));
        canvas.drawRect(this.frameRect, this.paint);
        canvas.drawRect(this.frameRect, this.eraser);
        this.drawCorners(canvas);
    }

    private void drawCorners(Canvas canvas) {
        this.paint.setStrokeWidth((float)this.cornerLineWidth);
        this.drawLine(canvas, this.frameRect.left - (float)(this.cornerLineWidth / 2), this.frameRect.top, this.cornerLength, 0);
        this.drawLine(canvas, this.frameRect.left, this.frameRect.top, 0, this.cornerLength);
        this.drawLine(canvas, this.frameRect.right + (float)(this.cornerLineWidth / 2), this.frameRect.top, -this.cornerLength, 0);
        this.drawLine(canvas, this.frameRect.right, this.frameRect.top, 0, this.cornerLength);
        this.drawLine(canvas, this.frameRect.right, this.frameRect.bottom, 0, -this.cornerLength);
        this.drawLine(canvas, this.frameRect.right + (float)(this.cornerLineWidth / 2), this.frameRect.bottom, -this.cornerLength, 0);
        this.drawLine(canvas, this.frameRect.left - (float)(this.cornerLineWidth / 2), this.frameRect.bottom, this.cornerLength, 0);
        this.drawLine(canvas, this.frameRect.left, this.frameRect.bottom, 0, -this.cornerLength);
    }

    private void drawLine(Canvas canvas, float x, float y, int dx, int dy) {
        canvas.drawLine(x, y, x + (float)dx, y + (float)dy, this.paint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = this.handleDown(event);
        float ex = 60.0f;
        RectF rectExtend = new RectF(this.frameRect.left - ex, this.frameRect.top - ex, this.frameRect.right + ex, this.frameRect.bottom + ex);
        if (!result && rectExtend.contains(event.getX(), event.getY())) {
            this.gestureDetector.onTouchEvent(event);
            return true;
        }
        return result;
    }

    private boolean handleDown(MotionEvent event) {
        switch (event.getAction()) {
            case 1: 
            case 3: {
                this.currentCorner = -1;
                break;
            }
            case 0: {
                float radius = this.cornerLength;
                this.touchRect.set(event.getX() - radius, event.getY() - radius, event.getX() + radius, event.getY() + radius);
                if (this.touchRect.contains(this.frameRect.left, this.frameRect.top)) {
                    this.currentCorner = 1;
                    return true;
                }
                if (this.touchRect.contains(this.frameRect.right, this.frameRect.top)) {
                    this.currentCorner = 2;
                    return true;
                }
                if (this.touchRect.contains(this.frameRect.right, this.frameRect.bottom)) {
                    this.currentCorner = 3;
                    return true;
                }
                if (this.touchRect.contains(this.frameRect.left, this.frameRect.bottom)) {
                    this.currentCorner = 4;
                    return true;
                }
                return false;
            }
            case 2: {
                return this.handleScale(event);
            }
        }
        return false;
    }

    private boolean handleScale(MotionEvent event) {
        switch (this.currentCorner) {
            case 1: {
                this.scaleTo(event.getX(), event.getY(), this.frameRect.right, this.frameRect.bottom);
                return true;
            }
            case 2: {
                this.scaleTo(this.frameRect.left, event.getY(), event.getX(), this.frameRect.bottom);
                return true;
            }
            case 3: {
                this.scaleTo(this.frameRect.left, this.frameRect.top, event.getX(), event.getY());
                return true;
            }
            case 4: {
                this.scaleTo(event.getX(), this.frameRect.top, this.frameRect.right, event.getY());
                return true;
            }
        }
        return false;
    }

    private void scaleTo(float left, float top, float right, float bottom) {
        if (bottom - top < this.getMinimumFrameHeight()) {
            top = this.frameRect.top;
            bottom = this.frameRect.bottom;
        }
        if (right - left < this.getMinimumFrameWidth()) {
            left = this.frameRect.left;
            right = this.frameRect.right;
        }
        left = Math.max((float)this.margin, left);
        top = Math.max((float)this.margin, top);
        right = Math.min((float)(this.getWidth() - this.margin), right);
        bottom = Math.min((float)(this.getHeight() - this.margin), bottom);
        this.frameRect.set(left, top, right, bottom);
        this.invalidate();
    }

    private void notifyFrameChange() {
        if (this.onFrameChangeListener != null) {
            this.onFrameChangeListener.onFrameChange(this.frameRect);
        }
    }

    private float getMinimumFrameWidth() {
        return 2.4f * (float)this.cornerLength;
    }

    private float getMinimumFrameHeight() {
        return 2.4f * (float)this.cornerLength;
    }

    static interface OnFrameChangeListener {
        public void onFrameChange(RectF var1);
    }
}

