/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.camera;

import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.support.v4.app.ActivityCompat;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import xin.dlong.ocr.ui.camera.CameraThreadPool;
import xin.dlong.ocr.ui.camera.CameraView;
import xin.dlong.ocr.ui.camera.ICameraControl;
import xin.dlong.ocr.ui.camera.PermissionCallback;

public class Camera1Control
implements ICameraControl {
    private int displayOrientation = 0;
    private int cameraId = 0;
    private int flashMode;
    private AtomicBoolean takingPicture = new AtomicBoolean(false);
    private AtomicBoolean abortingScan = new AtomicBoolean(false);
    private Context context;
    private Camera camera;
    private Camera.Parameters parameters;
    private PermissionCallback permissionCallback;
    private Rect previewFrame = new Rect();
    private PreviewView previewView;
    private View displayView;
    private int rotation = 0;
    private ICameraControl.OnDetectPictureCallback detectCallback;
    private int previewFrameCount = 0;
    private Camera.Size optSize;
    private final int MODEL_NOSCAN = 0;
    private final int MODEL_SCAN = 1;
    private int detectType = 0;
    private SurfaceTexture surfaceCache;
    private byte[] buffer = null;
    Camera.PreviewCallback previewCallback = new Camera.PreviewCallback(){

        public void onPreviewFrame(final byte[] data, Camera camera) {
            if (Camera1Control.this.abortingScan.get()) {
                return;
            }
            if (Camera1Control.this.previewFrameCount++ % 5 != 0) {
                return;
            }
            if ((double)data.length != (double)(((Camera1Control)Camera1Control.this).parameters.getPreviewSize().width * ((Camera1Control)Camera1Control.this).parameters.getPreviewSize().height) * 1.5) {
                return;
            }
            camera.addCallbackBuffer(Camera1Control.this.buffer);
            CameraThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    Camera1Control.this.onRequestDetect(data);
                }
            });
        }
    };
    private TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            Camera1Control.this.surfaceCache = surface;
            Camera1Control.this.initCamera();
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            Camera1Control.this.opPreviewSize(Camera1Control.this.previewView.getWidth(), Camera1Control.this.previewView.getHeight());
            Camera1Control.this.setPreviewCallbackImpl();
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            Camera1Control.this.setPreviewCallbackImpl();
        }
    };
    private Comparator<Camera.Size> sizeComparator = new Comparator<Camera.Size>(){

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            return Long.signum((long)lhs.width * (long)lhs.height - (long)rhs.width * (long)rhs.height);
        }
    };

    public int getCameraRotation() {
        return this.rotation;
    }

    @Override
    public AtomicBoolean getAbortingScan() {
        return this.abortingScan;
    }

    @Override
    public void setDetectCallback(ICameraControl.OnDetectPictureCallback callback) {
        this.detectType = 1;
        this.detectCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequestDetect(byte[] data) {
        if (this.camera == null || data == null) {
            return;
        }
        YuvImage img = new YuvImage(data, 17, this.optSize.width, this.optSize.height, null);
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream(data.length);
            img.compressToJpeg(new Rect(0, 0, this.optSize.width, this.optSize.height), 80, (OutputStream)os);
            byte[] jpeg = os.toByteArray();
            int status = this.detectCallback.onDetect(jpeg, this.getCameraRotation());
            if (status == 0) {
                this.clearPreviewCallback();
            }
        }
        catch (OutOfMemoryError e) {
        }
        finally {
            try {
                os.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDisplayOrientation(@CameraView.Orientation int displayOrientation) {
        this.displayOrientation = displayOrientation;
        switch (displayOrientation) {
            case 0: {
                this.rotation = 90;
                break;
            }
            case 90: {
                this.rotation = 0;
                break;
            }
            case 270: {
                this.rotation = 180;
                break;
            }
            default: {
                this.rotation = 0;
            }
        }
        this.previewView.requestLayout();
    }

    @Override
    public void refreshPermission() {
        this.startPreview(true);
    }

    @Override
    public void setFlashMode(@ICameraControl.FlashMode int flashMode) {
        if (this.flashMode == flashMode) {
            return;
        }
        this.flashMode = flashMode;
        this.updateFlashMode(flashMode);
    }

    @Override
    public int getFlashMode() {
        return this.flashMode;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.camera != null) {
            this.camera.setPreviewCallback(null);
            this.stopPreview();
            Camera tempC = this.camera;
            this.camera = null;
            tempC.release();
            this.camera = null;
            this.buffer = null;
        }
    }

    private void stopPreview() {
        if (this.camera != null) {
            CameraThreadPool.cancelAutoFocusTimer();
            this.camera.stopPreview();
        }
    }

    @Override
    public void pause() {
        if (this.camera != null) {
            this.stopPreview();
        }
        this.setFlashMode(0);
    }

    @Override
    public void resume() {
        this.takingPicture.set(false);
        if (this.camera == null) {
            this.openCamera();
        } else {
            this.previewView.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
            if (this.previewView.textureView.isAvailable()) {
                this.startPreview(false);
            }
        }
    }

    @Override
    public View getDisplayView() {
        return this.displayView;
    }

    @Override
    public void takePicture(final ICameraControl.OnTakePictureCallback onTakePictureCallback) {
        if (this.takingPicture.get()) {
            return;
        }
        switch (this.displayOrientation) {
            case 0: {
                this.parameters.setRotation(90);
                break;
            }
            case 90: {
                this.parameters.setRotation(0);
                break;
            }
            case 270: {
                this.parameters.setRotation(180);
            }
        }
        Camera.Size picSize = this.getOptimalSize(this.camera.getParameters().getSupportedPictureSizes());
        this.parameters.setPictureSize(picSize.width, picSize.height);
        this.camera.setParameters(this.parameters);
        this.takingPicture.set(true);
        try {
            this.camera.takePicture(null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Camera1Control.this.startPreview(false);
                    Camera1Control.this.takingPicture.set(false);
                    if (onTakePictureCallback != null) {
                        onTakePictureCallback.onPictureTaken(data);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.startPreview(false);
            this.takingPicture.set(false);
        }
    }

    @Override
    public void setPermissionCallback(PermissionCallback callback) {
        this.permissionCallback = callback;
    }

    public Camera1Control(Context context) {
        this.context = context;
        this.previewView = new PreviewView(context);
        this.openCamera();
    }

    private void openCamera() {
        this.setupDisplayView();
    }

    private void setupDisplayView() {
        TextureView textureView = new TextureView(this.context);
        this.previewView.textureView = textureView;
        this.previewView.setTextureView(textureView);
        this.displayView = this.previewView;
        textureView.setSurfaceTextureListener(this.surfaceTextureListener);
    }

    private void setPreviewCallbackImpl() {
        if (this.buffer == null) {
            this.buffer = new byte[this.displayView.getWidth() * this.displayView.getHeight() * ImageFormat.getBitsPerPixel((int)17) / 8];
        }
        if (this.camera != null && this.detectType == 1) {
            this.camera.addCallbackBuffer(this.buffer);
            this.camera.setPreviewCallback(this.previewCallback);
        }
    }

    private void clearPreviewCallback() {
        if (this.camera != null && this.detectType == 1) {
            this.camera.setPreviewCallback(null);
            this.stopPreview();
        }
    }

    private void initCamera() {
        try {
            if (this.camera == null) {
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 0) continue;
                    this.cameraId = i;
                }
                try {
                    this.camera = Camera.open((int)this.cameraId);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.startPreview(true);
                    return;
                }
            }
            if (this.parameters == null) {
                this.parameters = this.camera.getParameters();
                this.parameters.setPreviewFormat(17);
            }
            this.opPreviewSize(this.previewView.getWidth(), this.previewView.getHeight());
            this.camera.setPreviewTexture(this.surfaceCache);
            this.setPreviewCallbackImpl();
            this.startPreview(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startPreview(boolean checkPermission) {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") != 0) {
            if (checkPermission && this.permissionCallback != null) {
                this.permissionCallback.onRequestPermission();
            }
            return;
        }
        if (this.camera == null) {
            this.initCamera();
        } else {
            this.camera.startPreview();
            CameraThreadPool.createAutoFocusTimerTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Camera1Control camera1Control = Camera1Control.this;
                    synchronized (camera1Control) {
                        if (Camera1Control.this.camera != null && !Camera1Control.this.takingPicture.get()) {
                            Camera1Control.this.camera.autoFocus(new Camera.AutoFocusCallback(){

                                public void onAutoFocus(boolean success, Camera camera) {
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private void opPreviewSize(int width, int height) {
        if (this.parameters != null && this.camera != null && width > 0) {
            this.optSize = this.getOptimalSize(this.camera.getParameters().getSupportedPreviewSizes());
            this.parameters.setPreviewSize(this.optSize.width, this.optSize.height);
            this.previewView.setRatio(1.0f * (float)this.optSize.width / (float)this.optSize.height);
            this.camera.setDisplayOrientation(this.getSurfaceOrientation());
            this.stopPreview();
            try {
                this.camera.setParameters(this.parameters);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            this.startPreview(false);
        }
    }

    private Camera.Size getOptimalSize(List<Camera.Size> sizes) {
        int width = this.previewView.textureView.getWidth();
        int height = this.previewView.textureView.getHeight();
        Camera.Size pictureSize = sizes.get(0);
        ArrayList<Camera.Size> candidates = new ArrayList<Camera.Size>();
        for (Camera.Size size : sizes) {
            if (size.width >= width && size.height >= height && size.width * height == size.height * width) {
                candidates.add(size);
                continue;
            }
            if (size.height < width || size.width < height || size.width * width != size.height * height) continue;
            candidates.add(size);
        }
        if (!candidates.isEmpty()) {
            return Collections.min(candidates, this.sizeComparator);
        }
        for (Camera.Size size : sizes) {
            if (size.width <= width || size.height <= height) continue;
            return size;
        }
        return pictureSize;
    }

    private void updateFlashMode(int flashMode) {
        switch (flashMode) {
            case 1: {
                this.parameters.setFlashMode("torch");
                break;
            }
            case 0: {
                this.parameters.setFlashMode("off");
                break;
            }
            case 2: {
                this.parameters.setFlashMode("auto");
                break;
            }
            default: {
                this.parameters.setFlashMode("auto");
            }
        }
        this.camera.setParameters(this.parameters);
    }

    private int getSurfaceOrientation() {
        int orientation = this.displayOrientation;
        switch (orientation) {
            case 0: {
                return 90;
            }
            case 90: {
                return 0;
            }
            case 270: {
                return 180;
            }
        }
        return 90;
    }

    @Override
    public Rect getPreviewFrame() {
        return this.previewFrame;
    }

    private class PreviewView
    extends FrameLayout {
        private TextureView textureView;
        private float ratio;

        void setTextureView(TextureView textureView) {
            this.textureView = textureView;
            this.removeAllViews();
            this.addView((View)textureView);
        }

        void setRatio(float ratio) {
            this.ratio = ratio;
            this.requestLayout();
            this.relayout(this.getWidth(), this.getHeight());
        }

        public PreviewView(Context context) {
            super(context);
            this.ratio = 0.75f;
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            this.relayout(w, h);
        }

        private void relayout(int w, int h) {
            int width = w;
            int height = h;
            if (w < h) {
                height = (int)((float)width * this.ratio);
            } else {
                width = (int)((float)height * this.ratio);
            }
            int l = (this.getWidth() - width) / 2;
            int t = (this.getHeight() - height) / 2;
            ((Camera1Control)Camera1Control.this).previewFrame.left = l;
            ((Camera1Control)Camera1Control.this).previewFrame.top = t;
            ((Camera1Control)Camera1Control.this).previewFrame.right = l + width;
            ((Camera1Control)Camera1Control.this).previewFrame.bottom = t + height;
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            this.textureView.layout(((Camera1Control)Camera1Control.this).previewFrame.left, ((Camera1Control)Camera1Control.this).previewFrame.top, ((Camera1Control)Camera1Control.this).previewFrame.right, ((Camera1Control)Camera1Control.this).previewFrame.bottom);
        }
    }
}

