/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import xiaofei.library.concurrentutils.AugmentedListCanary;
import xiaofei.library.concurrentutils.util.Action;
import xiaofei.library.concurrentutils.util.Condition;
import xiaofei.library.shelly.function.Function;
import xiaofei.library.shelly.function.Function1;
import xiaofei.library.shelly.function.stashfunction.StashFunction;
import xiaofei.library.shelly.runnable.BlockingRunnable;
import xiaofei.library.shelly.runnable.ScheduledRunnable;
import xiaofei.library.shelly.scheduler.DefaultScheduler;
import xiaofei.library.shelly.scheduler.Scheduler;
import xiaofei.library.shelly.util.DoubleKeyMap;
import xiaofei.library.shelly.util.PlayerInputs;
import xiaofei.library.shelly.util.Tile;

public class Player<T> {
    private final AugmentedListCanary<PlayerInputs> mInputs = new AugmentedListCanary();
    private final DoubleKeyMap mStash;
    private Scheduler mScheduler;

    public Player(List<T> input) {
        this.mInputs.add((Object)new PlayerInputs(input, 0));
        this.mStash = new DoubleKeyMap();
        this.mScheduler = new DefaultScheduler();
    }

    public void setScheduler(Scheduler scheduler) {
        this.mScheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    public void prepare(Function function) {
        if (function instanceof StashFunction) {
            ((StashFunction)function).setStash(this.mStash);
        }
    }

    protected Runnable getRunnable(final Tile<T, ?> tile) {
        return new Runnable(){
            private int mIndex;
            {
                this.mIndex = Player.this.mInputs.size() - 1;
            }

            @Override
            public void run() {
                tile.call(((PlayerInputs)Player.this.mInputs.get(this.mIndex)).getInputs());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> Player<R> playRunnable(List<? extends Runnable> runnables) {
        Player player = this;
        synchronized (player) {
            if (this.mScheduler.isRunning()) {
                int size = this.mInputs.size();
                for (Runnable runnable : runnables) {
                    this.mScheduler.call(new ScheduledRunnable(this, runnable, size));
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> Player<R> playFunction(List<? extends Function1<CopyOnWriteArrayList<T>, CopyOnWriteArrayList<R>>> functions) {
        Player player = this;
        synchronized (player) {
            if (this.mScheduler.isRunning()) {
                int index = this.mInputs.add((Object)new PlayerInputs(functions.size())) - 1;
                for (Function1<CopyOnWriteArrayList<T>, CopyOnWriteArrayList<R>> function : functions) {
                    this.mScheduler.call(new ScheduledRunnable(this, new BlockingRunnable<T, R>(this, function, index), index));
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play(Tile<T, ?> tile) {
        Player player = this;
        synchronized (player) {
            if (this.mScheduler.isRunning()) {
                this.playRunnable(Collections.singletonList(this.getRunnable(tile)));
            }
        }
    }

    public void appendAt(int index, final CopyOnWriteArrayList<Object> object) {
        this.mInputs.action(index, (Action)new Action<PlayerInputs>(){

            public void call(PlayerInputs o) {
                o.getInputs().addAll(object);
                o.getFinishedNumber().getAndIncrement();
            }
        });
    }

    public final CopyOnWriteArrayList<Object> waitForFinishing() {
        int index = this.mInputs.size() - 1;
        return ((PlayerInputs)this.mInputs.get(index, (Condition)new Condition<PlayerInputs>(){

            public boolean satisfy(PlayerInputs o) {
                return o.getFinishedNumber().get() == o.getFunctionNumber();
            }
        })).getInputs();
    }

    public CopyOnWriteArrayList<Object> getInput(int index) {
        return ((PlayerInputs)this.mInputs.get(index)).getInputs();
    }

    public AugmentedListCanary<PlayerInputs> getInputs() {
        return this.mInputs;
    }
}

