/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.domino;

import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;
import xiaofei.library.shelly.Shelly;
import xiaofei.library.shelly.domino.Domino;
import xiaofei.library.shelly.function.Action0;
import xiaofei.library.shelly.function.Action1;
import xiaofei.library.shelly.function.Function1;
import xiaofei.library.shelly.function.TargetAction0;
import xiaofei.library.shelly.function.TargetAction1;
import xiaofei.library.shelly.operator.ListIdentityOperator;
import xiaofei.library.shelly.tuple.Triple;
import xiaofei.library.shelly.util.Tile;

public class RetrofitDomino<T, R>
extends Domino<T, Triple<Boolean, Response<R>, Throwable>> {
    public RetrofitDomino(Object label, Tile<T, Triple<Boolean, Response<R>, Throwable>> tile) {
        super(label, tile);
    }

    private RetrofitDomino(Domino<T, Triple<Boolean, Response<R>, Throwable>> domino) {
        this(domino.getLabel(), domino.getPlayer());
    }

    @Override
    public RetrofitDomino<T, R> uiThread() {
        return new RetrofitDomino(super.uiThread());
    }

    @Override
    public RetrofitDomino<T, R> background() {
        return new RetrofitDomino(super.background());
    }

    @Override
    public RetrofitDomino<T, R> backgroundQueue() {
        return new RetrofitDomino(super.backgroundQueue());
    }

    public RetrofitDomino<T, R> onFailure(Domino<? super Throwable, ?> domino) {
        return new RetrofitDomino(this.perform(Shelly.createAnonymousDomino().reduce(new Function1<List<Triple<Boolean, Response<R>, Throwable>>, List<Throwable>>(){

            @Override
            public List<Throwable> call(List<Triple<Boolean, Response<R>, Throwable>> input) {
                ArrayList<Throwable> result = new ArrayList<Throwable>();
                for (Triple triple : input) {
                    if (((Boolean)triple.first).booleanValue()) continue;
                    result.add((Throwable)triple.third);
                }
                return result;
            }
        }).flatMap(new ListIdentityOperator()).perform(domino)));
    }

    public <S> RetrofitDomino<T, R> onFailure(Class<? extends S> target, final TargetAction0<? super S> targetAction0) {
        return new RetrofitDomino(this.reduce(new ListIdentityOperator()).perform(target, new TargetAction1<S, List<Triple<Boolean, Response<R>, Throwable>>>(){

            @Override
            public void call(S s, List<Triple<Boolean, Response<R>, Throwable>> input) {
                boolean failure = false;
                for (Triple triple : input) {
                    if (((Boolean)triple.first).booleanValue()) continue;
                    failure = true;
                    break;
                }
                if (failure) {
                    targetAction0.call(s);
                }
            }
        }).flatMap(new ListIdentityOperator()));
    }

    public <S> RetrofitDomino<T, R> onFailure(Class<? extends S> target, final TargetAction1<? super S, ? super Throwable> targetAction1) {
        return new RetrofitDomino(this.perform(target, new TargetAction1<S, Triple<Boolean, Response<R>, Throwable>>(){

            @Override
            public void call(S s, Triple<Boolean, Response<R>, Throwable> input) {
                if (!((Boolean)input.first).booleanValue()) {
                    targetAction1.call(s, input.third);
                }
            }
        }));
    }

    public RetrofitDomino<T, R> onFailure(final Action0 action0) {
        return new RetrofitDomino(this.reduce(new ListIdentityOperator()).perform(new Action1<List<Triple<Boolean, Response<R>, Throwable>>>(){

            @Override
            public void call(List<Triple<Boolean, Response<R>, Throwable>> input) {
                boolean failure = false;
                for (Triple triple : input) {
                    if (((Boolean)triple.first).booleanValue()) continue;
                    failure = true;
                    break;
                }
                if (failure) {
                    action0.call();
                }
            }
        }).flatMap(new ListIdentityOperator()));
    }

    public RetrofitDomino<T, R> onFailure(final Action1<? super Throwable> action1) {
        return new RetrofitDomino(this.perform(new Action1<Triple<Boolean, Response<R>, Throwable>>(){

            @Override
            public void call(Triple<Boolean, Response<R>, Throwable> input) {
                if (!((Boolean)input.first).booleanValue()) {
                    action1.call(input.third);
                }
            }
        }));
    }

    public RetrofitDomino<T, R> finallyDo(Action0 action0) {
        return new RetrofitDomino(this.perform(action0));
    }

    public <S> RetrofitDomino<T, R> finallyDo(Class<? extends S> target, TargetAction0<? super S> targetAction0) {
        return new RetrofitDomino(this.perform(target, targetAction0));
    }

    private Domino<T, Triple<Boolean, Response<R>, Throwable>> toDomino() {
        return new Domino(this.getLabel(), this.getPlayer());
    }

    public Domino<T, R> endTask() {
        return this.endTask(new Function1<List<Triple<Boolean, Response<R>, Throwable>>, List<R>>(){

            @Override
            public List<R> call(List<Triple<Boolean, Response<R>, Throwable>> input) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Triple triple : input) {
                    if (!RetrofitDomino.responseSuccess(triple)) continue;
                    result.add(((Response)triple.second).body());
                }
                return result;
            }
        });
    }

    public <S> Domino<T, S> endTaskEmpty() {
        return this.toDomino().clear();
    }

    public <S> Domino<T, S> endTask(Function1<List<Triple<Boolean, Response<R>, Throwable>>, List<S>> reducer) {
        return this.toDomino().reduce(reducer).flatMap(new ListIdentityOperator());
    }

    private static <R> boolean responseSuccess(Triple<Boolean, Response<R>, Throwable> triple) {
        return (Boolean)triple.first != false && ((Response)triple.second).isSuccessful() && ((Response)triple.second).body() != null;
    }

    public RetrofitDomino<T, R> onSuccessResult(final Action0 action0) {
        return new RetrofitDomino(this.reduce(new ListIdentityOperator()).perform(new Action1<List<Triple<Boolean, Response<R>, Throwable>>>(){

            @Override
            public void call(List<Triple<Boolean, Response<R>, Throwable>> input) {
                boolean hasResult = false;
                for (Triple triple : input) {
                    if (!RetrofitDomino.responseSuccess(triple)) continue;
                    hasResult = true;
                    break;
                }
                if (hasResult) {
                    action0.call();
                }
            }
        }).flatMap(new ListIdentityOperator()));
    }

    public RetrofitDomino<T, R> onSuccessResult(final Action1<R> action1) {
        return new RetrofitDomino(this.perform(new Action1<Triple<Boolean, Response<R>, Throwable>>(){

            @Override
            public void call(Triple<Boolean, Response<R>, Throwable> input) {
                if (RetrofitDomino.responseSuccess(input)) {
                    action1.call(((Response)input.second).body());
                }
            }
        }));
    }

    public <S> RetrofitDomino<T, R> onSuccessResult(Class<? extends S> target, final TargetAction0<? super S> targetAction0) {
        return new RetrofitDomino(this.reduce(new ListIdentityOperator()).perform(target, new TargetAction1<S, List<Triple<Boolean, Response<R>, Throwable>>>(){

            @Override
            public void call(S s, List<Triple<Boolean, Response<R>, Throwable>> input) {
                boolean success = false;
                for (Triple triple : input) {
                    if (!RetrofitDomino.responseSuccess(triple)) continue;
                    success = true;
                    break;
                }
                if (success) {
                    targetAction0.call(s);
                }
            }
        }).flatMap(new ListIdentityOperator()));
    }

    public <S> RetrofitDomino<T, R> onSuccessResult(Class<? extends S> target, final TargetAction1<? super S, R> targetAction1) {
        return new RetrofitDomino(this.perform(target, new TargetAction1<S, Triple<Boolean, Response<R>, Throwable>>(){

            @Override
            public void call(S s, Triple<Boolean, Response<R>, Throwable> input) {
                if (RetrofitDomino.responseSuccess(input)) {
                    targetAction1.call(s, ((Response)input.second).body());
                }
            }
        }));
    }

    public RetrofitDomino<T, R> onSuccessResult(Domino<R, ?> domino) {
        return new RetrofitDomino(this.perform(Shelly.createAnonymousDomino().reduce(new Function1<List<Triple<Boolean, Response<R>, Throwable>>, List<R>>(){

            @Override
            public List<R> call(List<Triple<Boolean, Response<R>, Throwable>> input) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Triple triple : input) {
                    if (!RetrofitDomino.responseSuccess(triple)) continue;
                    result.add(((Response)triple.second).body());
                }
                return result;
            }
        }).flatMap(new ListIdentityOperator()).perform(domino)));
    }

    private static <R> boolean responseFailure(Triple<Boolean, Response<R>, Throwable> triple) {
        return (Boolean)triple.first != false && (((Response)triple.second).isSuccessful() && ((Response)triple.second).body() == null || !((Response)triple.second).isSuccessful());
    }

    public RetrofitDomino<T, R> onResponseFailure(final Action0 action0) {
        return new RetrofitDomino(this.reduce(new ListIdentityOperator()).perform(new Action1<List<Triple<Boolean, Response<R>, Throwable>>>(){

            @Override
            public void call(List<Triple<Boolean, Response<R>, Throwable>> input) {
                boolean failure = false;
                for (Triple triple : input) {
                    if (!RetrofitDomino.responseFailure(triple)) continue;
                    failure = true;
                    break;
                }
                if (failure) {
                    action0.call();
                }
            }
        }).flatMap(new ListIdentityOperator()));
    }

    public RetrofitDomino<T, R> onResponseFailure(final Action1<Response<R>> action1) {
        return new RetrofitDomino(this.perform(new Action1<Triple<Boolean, Response<R>, Throwable>>(){

            @Override
            public void call(Triple<Boolean, Response<R>, Throwable> input) {
                if (RetrofitDomino.responseFailure(input)) {
                    action1.call(input.second);
                }
            }
        }));
    }

    public <S> RetrofitDomino<T, R> onResponseFailure(Class<? extends S> target, final TargetAction0<? super S> targetAction0) {
        return new RetrofitDomino(this.reduce(new ListIdentityOperator()).perform(target, new TargetAction1<S, List<Triple<Boolean, Response<R>, Throwable>>>(){

            @Override
            public void call(S s, List<Triple<Boolean, Response<R>, Throwable>> input) {
                boolean failure = false;
                for (Triple triple : input) {
                    if (!RetrofitDomino.responseFailure(triple)) continue;
                    failure = true;
                    break;
                }
                if (failure) {
                    targetAction0.call(s);
                }
            }
        }).flatMap(new ListIdentityOperator()));
    }

    public <S> RetrofitDomino<T, R> onResponseFailure(Class<? extends S> target, final TargetAction1<? super S, Response<R>> targetAction1) {
        return new RetrofitDomino(this.perform(target, new TargetAction1<S, Triple<Boolean, Response<R>, Throwable>>(){

            @Override
            public void call(S s, Triple<Boolean, Response<R>, Throwable> input) {
                if (RetrofitDomino.responseFailure(input)) {
                    targetAction1.call(s, input.second);
                }
            }
        }));
    }

    public RetrofitDomino<T, R> onResponseFailure(Domino<Response<R>, ?> domino) {
        return new RetrofitDomino(this.perform(Shelly.createAnonymousDomino().reduce(new Function1<List<Triple<Boolean, Response<R>, Throwable>>, List<Response<R>>>(){

            @Override
            public List<Response<R>> call(List<Triple<Boolean, Response<R>, Throwable>> input) {
                ArrayList result = new ArrayList();
                for (Triple triple : input) {
                    if (!RetrofitDomino.responseFailure(triple)) continue;
                    result.add((Response)triple.second);
                }
                return result;
            }
        }).flatMap(new ListIdentityOperator()).perform(domino)));
    }
}

