/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.util;

import android.util.Log;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import xiaofei.library.shelly.domino.Domino;

public class DominoCenter {
    private static final String TAG = "DominoCenter";
    private static volatile DominoCenter sInstance = null;
    private final ConcurrentHashMap<Object, Domino<?, ?>> mDominoes = new ConcurrentHashMap();

    private DominoCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DominoCenter getInstance() {
        if (sInstance != null) return sInstance;
        Class<DominoCenter> clazz = DominoCenter.class;
        synchronized (DominoCenter.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DominoCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void commit(Domino<?, ?> domino) {
        Object label = domino.getLabel();
        if (label == null) {
            throw new UnsupportedOperationException("Domino label cannot be null. Please note that Domino created by Shelly.createDomino(Class<T>) can only be used temporarily and cannot be committed.");
        }
        if (this.mDominoes.put(label, domino) != null) {
            Log.w((String)TAG, (String)"Domino name duplicate! Check whether you have commit a domino with the same label before.");
        }
    }

    public <T> void play(Object label, CopyOnWriteArrayList<T> input) {
        Domino<?, ?> domino = this.mDominoes.get(label);
        if (domino == null) {
            throw new IllegalStateException("There is no domino labeled '" + label + "'.");
        }
        domino.play(input);
    }

    public <T, R> Domino<T, R> getDomino(Object label) {
        return this.mDominoes.get(label);
    }
}

