/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import xiaofei.library.shelly.scheduler.Scheduler;

public class ThrottleScheduler
extends Scheduler {
    private static final ScheduledExecutorService sExecutorService = Executors.newScheduledThreadPool(10);
    private static final ConcurrentHashMap<Object, Boolean> sRunningMap = new ConcurrentHashMap();
    private final Scheduler mScheduler;
    private final Object mLabel;
    private final long mDuration;
    private final TimeUnit mUnit;

    public ThrottleScheduler(Scheduler scheduler, Object label, long duration, TimeUnit unit) {
        this.mScheduler = scheduler;
        this.mLabel = label;
        this.mDuration = duration;
        this.mUnit = unit;
    }

    public void call(Runnable runnable) {
        Boolean running = sRunningMap.get(this.mLabel);
        if (running == null || running.booleanValue()) {
            this.mScheduler.call(runnable);
            sRunningMap.put(this.mLabel, false);
            sExecutorService.schedule(new ResumingRunnable(this.mLabel), this.mDuration, this.mUnit);
        } else {
            this.pause();
        }
    }

    private static class ResumingRunnable
    implements Runnable {
        private final Object mLabel;

        ResumingRunnable(Object label) {
            this.mLabel = label;
        }

        @Override
        public void run() {
            sRunningMap.put(this.mLabel, true);
        }
    }
}

