/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.util;

import xiaofei.library.concurrentutils.ObjectCanary;
import xiaofei.library.concurrentutils.util.Action;
import xiaofei.library.concurrentutils.util.Condition;
import xiaofei.library.concurrentutils.util.Function;
import xiaofei.library.shelly.function.Function1;
import xiaofei.library.shelly.function.Function2;
import xiaofei.library.shelly.task.Task;
import xiaofei.library.shelly.tuple.Triple;

public class TaskFunction<T, R1, R2, U1, U2>
implements Function1<T, Triple<Boolean, R2, U2>>,
Task.TaskListener<R1, U1> {
    private Task<T, R1, U1> mTask;
    private Function2<T, R1, R2> mFunc1;
    private Function2<T, U1, U2> mFunc2;
    private T mInput;
    private volatile ObjectCanary<ResultWrapper<R2, U2>> mResultWrapper;

    public TaskFunction(Task<T, R1, U1> task, Function2<T, R1, R2> func1, Function2<T, U1, U2> func2) {
        task.setListener(this);
        this.mTask = task;
        this.mFunc1 = func1;
        this.mFunc2 = func2;
        this.mResultWrapper = new ObjectCanary();
    }

    @Override
    public void onFailure(final U1 error) {
        this.mResultWrapper.action(new Action<ResultWrapper<R2, U2>>(){

            public void call(ResultWrapper<R2, U2> o) {
                o.setError(TaskFunction.this.mFunc2.call(TaskFunction.this.mInput, error));
            }
        });
    }

    @Override
    public void onSuccess(final R1 result) {
        this.mResultWrapper.action(new Action<ResultWrapper<R2, U2>>(){

            public void call(ResultWrapper<R2, U2> o) {
                o.setResult(TaskFunction.this.mFunc1.call(TaskFunction.this.mInput, result));
            }
        });
    }

    @Override
    public Triple<Boolean, R2, U2> call(T input) {
        this.mInput = input;
        this.mResultWrapper.set(new ResultWrapper());
        this.mTask.execute(input);
        this.mResultWrapper.wait(new Condition<ResultWrapper<R2, U2>>(){

            public boolean satisfy(ResultWrapper<R2, U2> o) {
                return o.getFlag() != -1;
            }
        });
        return Triple.create(this.mResultWrapper.calculate(new Function<ResultWrapper<R2, U2>, Boolean>(){

            public Boolean call(ResultWrapper<R2, U2> o) {
                return o.getFlag() == 1;
            }
        }), this.mResultWrapper.calculate(new Function<ResultWrapper<R2, U2>, R2>(){

            public R2 call(ResultWrapper<R2, U2> o) {
                return o.getResult();
            }
        }), this.mResultWrapper.calculate(new Function<ResultWrapper<R2, U2>, U2>(){

            public U2 call(ResultWrapper<R2, U2> o) {
                return o.getError();
            }
        }));
    }

    private static class ResultWrapper<T, R> {
        private volatile int mFlag = -1;
        private volatile T mResult = null;
        private volatile R mError = null;

        ResultWrapper() {
        }

        public void setError(R error) {
            this.mError = error;
            this.mFlag = 0;
        }

        public void setResult(T result) {
            this.mResult = result;
            this.mFlag = 1;
        }

        public R getError() {
            return this.mError;
        }

        public int getFlag() {
            return this.mFlag;
        }

        public T getResult() {
            return this.mResult;
        }
    }
}

