/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.scheduler;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xiaofei.library.shelly.runnable.ScheduledRunnable;
import xiaofei.library.shelly.scheduler.Scheduler;

public class UiThreadScheduler
extends Scheduler {
    private static Handler sHandler = new Handler(Looper.getMainLooper());
    private ExecutorService mExecutor = Executors.newSingleThreadExecutor();

    private void scheduleInternal(Runnable runnable) {
        boolean isMainThread;
        boolean bl = isMainThread = Looper.getMainLooper() == Looper.myLooper();
        if (isMainThread) {
            runnable.run();
        } else {
            sHandler.post(runnable);
        }
    }

    public void call(Runnable runnable) {
        if (runnable instanceof ScheduledRunnable) {
            final ScheduledRunnable scheduledRunnable = (ScheduledRunnable)runnable;
            if (!scheduledRunnable.inputSet()) {
                this.mExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        scheduledRunnable.waitForInput();
                        sHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                scheduledRunnable.getRunnable().run();
                            }
                        });
                    }
                });
            } else {
                this.scheduleInternal(scheduledRunnable.getRunnable());
            }
        } else {
            this.scheduleInternal(runnable);
        }
    }
}

