/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.domino;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import xiaofei.library.shelly.domino.RetrofitDomino;
import xiaofei.library.shelly.domino.RetrofitDomino2;
import xiaofei.library.shelly.domino.TaskDomino;
import xiaofei.library.shelly.domino.converter.DominoConverter;
import xiaofei.library.shelly.domino.converter.RetrofitDominoConverter;
import xiaofei.library.shelly.domino.converter.RetrofitDominoConverter2;
import xiaofei.library.shelly.function.Action0;
import xiaofei.library.shelly.function.Action1;
import xiaofei.library.shelly.function.Action2;
import xiaofei.library.shelly.function.Function1;
import xiaofei.library.shelly.function.Function2;
import xiaofei.library.shelly.function.TargetAction0;
import xiaofei.library.shelly.function.TargetAction1;
import xiaofei.library.shelly.operator.EmptyOperator;
import xiaofei.library.shelly.operator.FilterOperator;
import xiaofei.library.shelly.operator.FlatMapOperator;
import xiaofei.library.shelly.operator.ListIdentityOperator;
import xiaofei.library.shelly.operator.MapOperator;
import xiaofei.library.shelly.operator.MapOperator2;
import xiaofei.library.shelly.operator.ReducerOperator;
import xiaofei.library.shelly.operator.RightRefinementOperator;
import xiaofei.library.shelly.scheduler.BackgroundQueueScheduler;
import xiaofei.library.shelly.scheduler.BackgroundScheduler;
import xiaofei.library.shelly.scheduler.DefaultScheduler;
import xiaofei.library.shelly.scheduler.NewThreadScheduler;
import xiaofei.library.shelly.scheduler.Scheduler;
import xiaofei.library.shelly.scheduler.ThrottleScheduler;
import xiaofei.library.shelly.scheduler.UiThreadScheduler;
import xiaofei.library.shelly.task.AbstractRetrofitTask;
import xiaofei.library.shelly.task.Task;
import xiaofei.library.shelly.tuple.Pair;
import xiaofei.library.shelly.tuple.Triple;
import xiaofei.library.shelly.util.DominoCenter;
import xiaofei.library.shelly.util.Player;
import xiaofei.library.shelly.util.TargetCenter;
import xiaofei.library.shelly.util.TaskFunction;
import xiaofei.library.shelly.util.Tile;

public class Domino<T, R> {
    protected static final DominoCenter DOMINO_CENTER = DominoCenter.getInstance();
    protected static final TargetCenter TARGET_CENTER = TargetCenter.getInstance();
    private Tile<T, R> mTile;
    private Object mLabel;

    public Domino(Object label) {
        this(label, new Tile<T, R>(){

            @Override
            public Player<R> call(List<T> input) {
                return new Player(input);
            }
        });
    }

    public Domino(Object label, Tile<T, R> tile) {
        this.mLabel = label;
        this.mTile = tile;
    }

    public Object getLabel() {
        return this.mLabel;
    }

    public Tile<T, R> getPlayer() {
        return this.mTile;
    }

    public <S extends Domino<T, ?>> S convert(DominoConverter<T, R, S> converter) {
        return (S)((Domino)converter.call(this));
    }

    public <U> Domino<T, R> perform(final Class<? extends U> target, final TargetAction0<? super U> targetAction0) {
        return this.performInternal(new Action2<Player<R>, List<R>>(){

            @Override
            public void call(Player<R> player, List<R> input) {
                CopyOnWriteArrayList<Object> objects = TARGET_CENTER.getObjects(target);
                player.prepare(targetAction0);
                for (Object object : objects) {
                    targetAction0.call(target.cast(object));
                }
            }
        });
    }

    public <U> Domino<T, R> perform(final Class<? extends U> target, final TargetAction1<? super U, ? super R> targetAction1) {
        return this.performInternal(new Action2<Player<R>, List<R>>(){

            @Override
            public void call(Player<R> player, List<R> input) {
                CopyOnWriteArrayList<Object> objects = TARGET_CENTER.getObjects(target);
                player.prepare(targetAction1);
                for (Object object : objects) {
                    for (Object singleInput : input) {
                        targetAction1.call(target.cast(object), singleInput);
                    }
                }
            }
        });
    }

    public Domino<T, R> perform(final Action0 action0) {
        return this.performInternal(new Action2<Player<R>, List<R>>(){

            @Override
            public void call(Player<R> player, List<R> input) {
                player.prepare(action0);
                action0.call();
            }
        });
    }

    public Domino<T, R> perform(final Action1<? super R> action1) {
        return this.performInternal(new Action2<Player<R>, List<R>>(){

            @Override
            public void call(Player<R> player, List<R> input) {
                player.prepare(action1);
                for (Object singleInput : input) {
                    action1.call(singleInput);
                }
            }
        });
    }

    public Domino<T, R> perform(final Domino<? super R, ?> domino) {
        return this.performInternal(new Action2<Player<R>, List<R>>(){

            @Override
            public void call(Player<R> player, List<R> input) {
                domino.mTile.call(input);
            }
        });
    }

    private Domino<T, R> performInternal(final Action2<Player<R>, List<R>> action2) {
        return new Domino<T, R>(this.mLabel, new Tile<T, R>(){

            @Override
            public Player<R> call(List<T> input) {
                final Player player = (Player)Domino.this.mTile.call(input);
                player.play(new Tile<R, R>(){

                    @Override
                    public Player<R> call(List<R> input) {
                        action2.call(player, input);
                        return player;
                    }
                });
                return player;
            }
        });
    }

    public <U> Domino<T, U> dominoMap(Domino<? super R, ? extends U> domino) {
        return this.merge(new Domino[]{domino});
    }

    public <U> Domino<T, U> merge(Domino<? super R, ? extends U> domino1, Domino<? super R, ? extends U> domino2) {
        return this.merge(new Domino[]{domino1, domino2});
    }

    public <U> Domino<T, U> merge(Domino<? super R, ? extends U> domino1, Domino<? super R, ? extends U> domino2, Domino<? super R, ? extends U> domino3) {
        return this.merge(new Domino[]{domino1, domino2, domino3});
    }

    public <U> Domino<T, U> merge(final Domino<? super R, ? extends U>[] dominoes) {
        return new Domino<T, R>(this.mLabel, new Tile<T, U>(){

            @Override
            public Player<U> call(List<T> input) {
                Player player = (Player)Domino.this.mTile.call(input);
                ArrayList<1> functions = new ArrayList<1>();
                for (final Domino domino : dominoes) {
                    functions.add(new Function1<CopyOnWriteArrayList<R>, CopyOnWriteArrayList<U>>(){

                        @Override
                        public CopyOnWriteArrayList<U> call(CopyOnWriteArrayList<R> input) {
                            Player player = (Player)domino.mTile.call(input);
                            return player.waitForFinishing();
                        }
                    });
                }
                return player.playFunction(functions);
            }
        });
    }

    public <S1, S2, V> Domino<T, V> combine(Domino<? super R, S1> domino1, Domino<? super R, S2> domino2, final Function2<? super S1, ? super S2, ? extends V> combiner) {
        return this.merge(domino1.reduce(new Function1<List<S1>, Pair<Integer, List<Object>>>(){

            @Override
            public Pair<Integer, List<Object>> call(List<S1> input) {
                return Pair.create(1, input);
            }
        }), domino2.reduce(new Function1<List<S2>, Pair<Integer, List<Object>>>(){

            @Override
            public Pair<Integer, List<Object>> call(List<S2> input) {
                return Pair.create(2, input);
            }
        })).reduce(new Function1<List<Pair<Integer, List<Object>>>, List<V>>(){

            @Override
            public List<V> call(List<Pair<Integer, List<Object>>> input) {
                List input2;
                List input1;
                if (input.size() != 2) {
                    throw new IllegalStateException("Unknown error! Please report this to Xiaofei.");
                }
                ArrayList result = new ArrayList();
                if ((Integer)input.get((int)0).first == 1) {
                    input1 = (List)input.get((int)0).second;
                    input2 = (List)input.get((int)1).second;
                } else {
                    input1 = (List)input.get((int)1).second;
                    input2 = (List)input.get((int)0).second;
                }
                for (Object o1 : input1) {
                    for (Object o2 : input2) {
                        result.add(combiner.call(o1, o2));
                    }
                }
                return result;
            }
        }).flatMap(new ListIdentityOperator());
    }

    public <S1, S2, U1, U2, V> Domino<T, V> combineTask(TaskDomino<? super R, S1, U1> taskDomino1, TaskDomino<? super R, S2, U2> taskDomino2, Function2<? super S1, ? super S2, ? extends V> combiner) {
        return this.combine(taskDomino1.map(new Function1<Triple<Boolean, S1, U1>, S1>(){

            @Override
            public S1 call(Triple<Boolean, S1, U1> input) {
                return (Boolean)input.first != false ? (Object)input.second : null;
            }
        }), taskDomino2.map(new Function1<Triple<Boolean, S2, U2>, S2>(){

            @Override
            public S2 call(Triple<Boolean, S2, U2> input) {
                return (Boolean)input.first != false ? (Object)input.second : null;
            }
        }), combiner);
    }

    private Domino<T, R> schedule(final Scheduler scheduler) {
        return new Domino<T, R>(this.mLabel, new Tile<T, R>(){

            @Override
            public Player<R> call(List<T> input) {
                Player player = (Player)Domino.this.mTile.call(input);
                player.setScheduler(scheduler);
                return player;
            }
        });
    }

    public Domino<T, R> background() {
        return this.schedule(new BackgroundScheduler());
    }

    Domino<T, R> newThread() {
        return this.schedule(new NewThreadScheduler());
    }

    Domino<T, R> defaultScheduler() {
        return this.schedule(new DefaultScheduler());
    }

    public Domino<T, R> uiThread() {
        return this.schedule(new UiThreadScheduler());
    }

    public Domino<T, R> backgroundQueue() {
        return this.schedule(new BackgroundQueueScheduler());
    }

    public Domino<T, R> throttle(final long windowDuration, final TimeUnit unit) {
        return new Domino<T, R>(this.mLabel, new Tile<T, R>(){

            @Override
            public Player<R> call(List<T> input) {
                Player player = (Player)Domino.this.mTile.call(input);
                player.setScheduler(new ThrottleScheduler(player.getScheduler(), Domino.this.mLabel, windowDuration, unit));
                return player;
            }
        });
    }

    public <U> Domino<T, U> lift(final Function1<CopyOnWriteArrayList<R>, CopyOnWriteArrayList<U>> function) {
        return new Domino<T, R>(this.mLabel, new Tile<T, U>(){

            @Override
            public Player<U> call(List<T> input) {
                Player player = (Player)Domino.this.mTile.call(input);
                return player.playFunction(Collections.singletonList(function));
            }
        });
    }

    public <U> Domino<T, U> map(Function1<? super R, ? extends U> map) {
        return this.lift(new MapOperator<R, U>(map));
    }

    public <U, S> Domino<T, U> map(Class<S> target, Function2<? super S, ? super R, ? extends U> map) {
        return this.lift(new MapOperator2<R, U, S>(target, map));
    }

    public <U> Domino<T, U> flatMap(Function1<? super R, List<U>> map) {
        return this.lift(new FlatMapOperator<R, U>(map));
    }

    public Domino<T, R> filter(Function1<? super R, Boolean> filter) {
        return this.lift(new FilterOperator<R>(filter));
    }

    public <U> Domino<T, U> reduce(Function1<List<R>, ? extends U> reducer) {
        return this.lift(new ReducerOperator<R, U>(reducer));
    }

    public <U> Domino<T, U> clear() {
        return this.lift(new EmptyOperator());
    }

    public <U, S> TaskDomino<T, U, S> beginTask(Task<R, U, S> task) {
        Domino<T, U> domino = this.map(new TaskFunction(task, new RightRefinementOperator(), new RightRefinementOperator()));
        return new TaskDomino(domino.getLabel(), domino.getPlayer());
    }

    public <U1, U2, S1, S2> TaskDomino<T, U2, S2> beginTask(Task<R, U1, S1> task, Function2<R, U1, U2> func1, Function2<R, S1, S2> func2) {
        Domino domino = this.map(new TaskFunction<R, U1, U2, S1, S2>(task, func1, func2));
        return new TaskDomino(domino.getLabel(), domino.getPlayer());
    }

    public <U, S> TaskDomino<T, Pair<R, U>, S> beginTaskKeepingInput(Task<R, U, S> task) {
        Domino<T, U> domino = this.map(new TaskFunction(task, new Function2<R, U, Pair<R, U>>(){

            @Override
            public Pair<R, U> call(R input1, U input2) {
                return Pair.create(input1, input2);
            }
        }, new RightRefinementOperator()));
        return new TaskDomino(domino.getLabel(), domino.getPlayer());
    }

    public <U> RetrofitDomino<T, U> beginRetrofitTask(AbstractRetrofitTask<R, U> task) {
        return (RetrofitDomino)this.beginTask(task).convert(new RetrofitDominoConverter());
    }

    public <U> RetrofitDomino2<T, R, U> beginRetrofitTaskKeepingInput(AbstractRetrofitTask<R, U> task) {
        return (RetrofitDomino2)this.beginTaskKeepingInput(task).convert(new RetrofitDominoConverter2());
    }

    public void play(CopyOnWriteArrayList<T> input) {
        this.mTile.call(input);
    }

    public void commit() {
        DOMINO_CENTER.commit(this);
    }
}

