/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.util;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SchedulerInputs {
    private final CopyOnWriteArrayList<CopyOnWriteArrayList<Object>> mInputs = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ReentrantLock> mLocks = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Condition> mConditions = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Integer> mFunctionNumber = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<AtomicInteger> mFinishedNumber = new CopyOnWriteArrayList();

    public int append(int functionNumber) {
        return this.addInternal(new CopyOnWriteArrayList<Object>(), functionNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addInternal(CopyOnWriteArrayList<Object> input, int functionNumber) {
        SchedulerInputs schedulerInputs = this;
        synchronized (schedulerInputs) {
            this.mInputs.add(input);
            ReentrantLock lock = new ReentrantLock();
            this.mLocks.add(lock);
            this.mConditions.add(lock.newCondition());
            this.mFunctionNumber.add(functionNumber);
            this.mFinishedNumber.add(new AtomicInteger(0));
            return this.mInputs.size();
        }
    }

    public void add(CopyOnWriteArrayList<Object> input) {
        this.addInternal(input, 0);
    }

    public boolean inputSet(int index) {
        return this.mFinishedNumber.get(index).get() == this.mFunctionNumber.get(index).intValue();
    }

    public int size() {
        return this.mInputs.size();
    }

    public CopyOnWriteArrayList<Object> get(int index) {
        return this.mInputs.get(index);
    }

    public void set(int index, CopyOnWriteArrayList<Object> input) {
        this.lock(index);
        this.mInputs.get(index).addAll(input);
        if (this.mFinishedNumber.get(index).incrementAndGet() == this.mFunctionNumber.get(index).intValue()) {
            this.mConditions.get(index).signalAll();
        }
        this.unlock(index);
    }

    public void lock(int index) {
        this.mLocks.get(index).lock();
    }

    public void unlock(int index) {
        this.mLocks.get(index).unlock();
    }

    public void await(int index) throws InterruptedException {
        this.mConditions.get(index).await();
    }
}

