/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.util;

import java.util.concurrent.CopyOnWriteArrayList;
import xiaofei.library.shelly.function.Function1;
import xiaofei.library.shelly.scheduler.Scheduler;

public class BlockingRunnable<T, R>
implements Runnable {
    private Scheduler<T> mScheduler;
    private int mIndex;
    private Function1<CopyOnWriteArrayList<T>, CopyOnWriteArrayList<R>> mFunction;

    public BlockingRunnable(Scheduler<T> scheduler, Function1<CopyOnWriteArrayList<T>, CopyOnWriteArrayList<R>> function, int index) {
        this.mScheduler = scheduler;
        this.mFunction = function;
        this.mIndex = index;
    }

    protected final CopyOnWriteArrayList<T> getPreviousInput() {
        return this.mScheduler.getInput(this.mIndex - 1);
    }

    @Override
    public final void run() {
        CopyOnWriteArrayList<Object> input = this.mFunction.call(this.getPreviousInput());
        if (input == null) {
            throw new IllegalStateException();
        }
        this.mScheduler.unblock(this.mIndex, input);
    }
}

