/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.scheduler;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xiaofei.library.shelly.scheduler.Scheduler;
import xiaofei.library.shelly.util.ScheduledRunnable;

public class UiThreadScheduler<T>
extends Scheduler<T> {
    private static Handler sHandler = new Handler(Looper.getMainLooper());
    private static ExecutorService sExecutor = Executors.newCachedThreadPool();

    public <R> UiThreadScheduler(Scheduler<R> scheduler) {
        super(scheduler);
    }

    private void scheduleInternal(Runnable runnable) {
        boolean isMainThread;
        boolean bl = isMainThread = Looper.getMainLooper() == Looper.myLooper();
        if (isMainThread) {
            runnable.run();
        } else {
            sHandler.post(runnable);
        }
    }

    @Override
    protected void onSchedule(Runnable runnable) {
        if (runnable instanceof ScheduledRunnable) {
            final ScheduledRunnable scheduledRunnable = (ScheduledRunnable)runnable;
            if (!scheduledRunnable.inputSet()) {
                sExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        scheduledRunnable.waitForInput();
                        sHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                scheduledRunnable.getRunnable().run();
                            }
                        });
                    }
                });
            } else {
                this.scheduleInternal(scheduledRunnable.getRunnable());
            }
        } else {
            this.scheduleInternal(runnable);
        }
    }
}

