/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import xiaofei.library.shelly.scheduler.Scheduler;

public class ThrottleScheduler<T>
extends Scheduler<T> {
    private static ScheduledExecutorService sExecutorService = Executors.newScheduledThreadPool(10);
    private static ConcurrentHashMap<Object, Boolean> sRunningMap = new ConcurrentHashMap();
    private Scheduler<T> mScheduler;
    private Object mLabel;
    private long mDuration;
    private TimeUnit mUnit;

    public ThrottleScheduler(Scheduler<T> scheduler, Object label, long duration, TimeUnit unit) {
        super(scheduler);
        this.mScheduler = scheduler;
        this.mLabel = label;
        this.mDuration = duration;
        this.mUnit = unit;
    }

    @Override
    protected void onSchedule(Runnable runnable) {
        Boolean running = sRunningMap.get(this.mLabel);
        if (running == null || running.booleanValue()) {
            this.mScheduler.onSchedule(runnable);
            sRunningMap.put(this.mLabel, false);
            sExecutorService.schedule(new ResumeRunnable(this.mLabel), this.mDuration, this.mUnit);
        } else {
            this.pause();
        }
    }

    private static class ResumeRunnable
    implements Runnable {
        private Object mLabel;

        ResumeRunnable(Object label) {
            this.mLabel = label;
        }

        @Override
        public void run() {
            sRunningMap.put(this.mLabel, true);
        }
    }
}

