/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly.scheduler;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import xiaofei.library.shelly.function.Function1;
import xiaofei.library.shelly.util.BlockingRunnable;
import xiaofei.library.shelly.util.Player;
import xiaofei.library.shelly.util.ScheduledRunnable;
import xiaofei.library.shelly.util.SchedulerInputs;

public abstract class Scheduler<T> {
    private static final int STATE_RUNNING = 0;
    private static final int STATE_PAUSE = 1;
    private int mState;
    private final SchedulerInputs mInputs;

    public Scheduler(List<T> input) {
        this.mInputs = new SchedulerInputs();
        if (input instanceof CopyOnWriteArrayList) {
            this.mInputs.add((CopyOnWriteArrayList)input);
        } else {
            this.mInputs.add(new CopyOnWriteArrayList<Object>(input));
        }
        this.mState = 0;
    }

    public <R> Scheduler(Scheduler<R> scheduler) {
        this.mInputs = scheduler.mInputs;
        this.mState = scheduler.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.mState = 1;
        }
    }

    protected boolean isRunning() {
        return this.mState == 0;
    }

    protected Runnable onPlay(final Player<T, ?> player) {
        return new Runnable(){
            private int mIndex;
            {
                this.mIndex = Scheduler.this.mInputs.size() - 1;
            }

            @Override
            public void run() {
                player.call(Scheduler.this.mInputs.get(this.mIndex));
            }
        };
    }

    protected abstract void onSchedule(Runnable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> Scheduler<R> scheduleRunnable(List<? extends Runnable> runnables) {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.isRunning()) {
                int size = this.mInputs.size();
                for (Runnable runnable : runnables) {
                    this.onSchedule(new ScheduledRunnable(this, runnable, size));
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> Scheduler<R> scheduleFunction(List<? extends Function1<CopyOnWriteArrayList<T>, CopyOnWriteArrayList<R>>> functions) {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.isRunning()) {
                int index = this.block(functions.size());
                for (Function1<CopyOnWriteArrayList<T>, CopyOnWriteArrayList<R>> function : functions) {
                    this.onSchedule(new ScheduledRunnable(this, new BlockingRunnable<T, R>(this, function, index), index));
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play(Player<T, ?> player) {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.isRunning()) {
                this.scheduleRunnable(Collections.singletonList(this.onPlay(player)));
            }
        }
    }

    private int block(int functionNumber) {
        return this.mInputs.append(functionNumber) - 1;
    }

    public void unblock(int index, CopyOnWriteArrayList<Object> object) {
        this.mInputs.set(index, object);
    }

    public final CopyOnWriteArrayList<Object> waitForFinishing() {
        int index = this.mInputs.size() - 1;
        try {
            this.mInputs.lock(index);
            while (!this.mInputs.inputSet(index)) {
                this.mInputs.await(index);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.mInputs.unlock(index);
        }
        return this.mInputs.get(index);
    }

    public CopyOnWriteArrayList<Object> getInput(int index) {
        return this.mInputs.get(index);
    }

    public SchedulerInputs getInputs() {
        return this.mInputs;
    }
}

