/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly;

import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArrayList;
import xiaofei.library.shelly.Domino;
import xiaofei.library.shelly.util.DominoCenter;
import xiaofei.library.shelly.util.TargetCenter;

public class Shelly {
    private static final TargetCenter TARGET_CENTER = TargetCenter.getInstance();
    private static final DominoCenter DOMINO_CENTER = DominoCenter.getInstance();

    public static void register(Object object) {
        TARGET_CENTER.register(object);
    }

    public static boolean isRegistered(Object object) {
        return TARGET_CENTER.isRegistered(object);
    }

    public static void unregister(Object object) {
        TARGET_CENTER.unregister(object);
    }

    public static <T> Domino<T, T> createDomino(Object label) {
        if (label != null && DOMINO_CENTER.containsDomino(label)) {
            throw new IllegalArgumentException("Domino labeled with " + label + " have been committed before. Please specify another label.");
        }
        return new Domino(label);
    }

    public static <T> Domino<T, T> createDomino() {
        return new Domino(null);
    }

    @SafeVarargs
    public static <T> void playDomino(Object label, T ... input) {
        CopyOnWriteArrayList<T> newInput = new CopyOnWriteArrayList<T>();
        if (input == null) {
            newInput.add(null);
        } else if (input.length > 0) {
            newInput.addAll(Arrays.asList(input));
        }
        Shelly.playDominoInternal(label, newInput);
    }

    public static void playDomino(Object label) {
        Shelly.playDominoInternal(label, new CopyOnWriteArrayList());
    }

    private static <T> void playDominoInternal(Object label, CopyOnWriteArrayList<T> input) {
        DOMINO_CENTER.play(label, input);
    }

    public static <T, R> Domino<T, R> getDominoByLabel(Object label) {
        return DOMINO_CENTER.getDomino(label);
    }
}

