/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly;

import android.support.v4.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import xiaofei.library.shelly.TaskDomino;
import xiaofei.library.shelly.function.Action0;
import xiaofei.library.shelly.function.Action1;
import xiaofei.library.shelly.function.Function1;
import xiaofei.library.shelly.function.Function2;
import xiaofei.library.shelly.function.TargetAction0;
import xiaofei.library.shelly.function.TargetAction1;
import xiaofei.library.shelly.operator.EmptyOperator;
import xiaofei.library.shelly.operator.FilterOperator;
import xiaofei.library.shelly.operator.FlatMapOperator;
import xiaofei.library.shelly.operator.MapOperator;
import xiaofei.library.shelly.operator.MapOperator2;
import xiaofei.library.shelly.operator.ReducerOperator;
import xiaofei.library.shelly.scheduler.BackgroundQueueScheduler;
import xiaofei.library.shelly.scheduler.BackgroundScheduler;
import xiaofei.library.shelly.scheduler.DefaultScheduler;
import xiaofei.library.shelly.scheduler.NewThreadScheduler;
import xiaofei.library.shelly.scheduler.Scheduler;
import xiaofei.library.shelly.scheduler.ThrottleScheduler;
import xiaofei.library.shelly.scheduler.UiThreadScheduler;
import xiaofei.library.shelly.util.DominoCenter;
import xiaofei.library.shelly.util.Player;
import xiaofei.library.shelly.util.TargetCenter;
import xiaofei.library.shelly.util.Task;
import xiaofei.library.shelly.util.Triple;

public class Domino<T, R> {
    protected static final DominoCenter DOMINO_CENTER = DominoCenter.getInstance();
    protected static final TargetCenter TARGET_CENTER = TargetCenter.getInstance();
    private Player<T, R> mPlayer;
    private Object mLabel;

    Domino(Object label) {
        this(label, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                return new DefaultScheduler(input);
            }
        });
    }

    Domino(Object label, Player<T, R> player) {
        this.mLabel = label;
        this.mPlayer = player;
    }

    public Object getLabel() {
        return this.mLabel;
    }

    protected Player<T, R> getPlayer() {
        return this.mPlayer;
    }

    public <U> Domino<T, R> target(final Class<? extends U> clazz, final TargetAction0<? super U> targetAction0) {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                final Scheduler scheduler = Domino.this.mPlayer.call(input);
                scheduler.play(new Player<R, R>(){

                    @Override
                    public Scheduler<R> call(List<R> input) {
                        CopyOnWriteArrayList<Object> objects = TARGET_CENTER.getObjects(clazz);
                        for (Object object : objects) {
                            targetAction0.call(clazz.cast(object));
                        }
                        return scheduler;
                    }
                });
                return scheduler;
            }
        });
    }

    public <U> Domino<T, R> target(final Class<? extends U> clazz, final TargetAction1<? super U, ? super R> targetAction1) {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                final Scheduler scheduler = Domino.this.mPlayer.call(input);
                scheduler.play(new Player<R, R>(){

                    @Override
                    public Scheduler<R> call(List<R> input) {
                        CopyOnWriteArrayList<Object> objects = TARGET_CENTER.getObjects(clazz);
                        for (Object object : objects) {
                            for (Object singleInput : input) {
                                targetAction1.call(clazz.cast(object), singleInput);
                            }
                        }
                        return scheduler;
                    }
                });
                return scheduler;
            }
        });
    }

    public Domino<T, R> target(final Action0 action0) {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                final Scheduler scheduler = Domino.this.mPlayer.call(input);
                scheduler.play(new Player<R, R>(){

                    @Override
                    public Scheduler<R> call(List<R> input) {
                        action0.call();
                        return scheduler;
                    }
                });
                return scheduler;
            }
        });
    }

    public Domino<T, R> target(final Action1<? super R> action1) {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                final Scheduler scheduler = Domino.this.mPlayer.call(input);
                scheduler.play(new Player<R, R>(){

                    @Override
                    public Scheduler<R> call(List<R> input) {
                        for (Object singleInput : input) {
                            action1.call(singleInput);
                        }
                        return scheduler;
                    }
                });
                return scheduler;
            }
        });
    }

    public Domino<T, R> target(final Domino<? super R, ?> domino) {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                final Scheduler scheduler = Domino.this.mPlayer.call(input);
                scheduler.play(new Player<R, R>(){

                    @Override
                    public Scheduler<R> call(List<R> input) {
                        domino.mPlayer.call(input);
                        return scheduler;
                    }
                });
                return scheduler;
            }
        });
    }

    public <U> Domino<T, U> dominoMap(Domino<? super R, ? extends U> domino) {
        return this.merge(new Domino[]{domino});
    }

    public <U> Domino<T, U> merge(Domino<? super R, ? extends U> domino1, Domino<? super R, ? extends U> domino2) {
        return this.merge(new Domino[]{domino1, domino2});
    }

    public <U> Domino<T, U> merge(Domino<? super R, ? extends U> domino1, Domino<? super R, ? extends U> domino2, Domino<? super R, ? extends U> domino3) {
        return this.merge(new Domino[]{domino1, domino2, domino3});
    }

    public <U> Domino<T, U> merge(final Domino<? super R, ? extends U>[] dominoes) {
        return new Domino<T, R>(this.mLabel, new Player<T, U>(){

            @Override
            public Scheduler<U> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                ArrayList<1> functions = new ArrayList<1>();
                for (final Domino domino : dominoes) {
                    functions.add(new Function1<CopyOnWriteArrayList<R>, CopyOnWriteArrayList<U>>(){

                        @Override
                        public CopyOnWriteArrayList<U> call(CopyOnWriteArrayList<R> input) {
                            Scheduler scheduler = domino.mPlayer.call(input);
                            return scheduler.waitForFinishing();
                        }
                    });
                }
                return scheduler.scheduleFunction(functions);
            }
        });
    }

    public <S1, S2, V> Domino<T, V> combine(Domino<? super R, S1> domino1, Domino<? super R, S2> domino2, final Function2<? super S1, ? super S2, ? extends V> combiner) {
        return this.merge(domino1.reduce(new Function1<List<S1>, Pair<Integer, List<Object>>>(){

            @Override
            public Pair<Integer, List<Object>> call(List<S1> input) {
                return new Pair((Object)1, input);
            }
        }), domino2.reduce(new Function1<List<S2>, Pair<Integer, List<Object>>>(){

            @Override
            public Pair<Integer, List<Object>> call(List<S2> input) {
                return new Pair((Object)2, input);
            }
        })).reduce(new Function1<List<Pair<Integer, List<Object>>>, List<V>>(){

            @Override
            public List<V> call(List<Pair<Integer, List<Object>>> input) {
                List input2;
                List input1;
                if (input.size() != 2) {
                    throw new IllegalStateException("Unknown error! Please report this to Xiaofei.");
                }
                ArrayList result = new ArrayList();
                if ((Integer)input.get((int)0).first == 1) {
                    input1 = (List)input.get((int)0).second;
                    input2 = (List)input.get((int)1).second;
                } else {
                    input1 = (List)input.get((int)1).second;
                    input2 = (List)input.get((int)0).second;
                }
                for (Object o1 : input1) {
                    for (Object o2 : input2) {
                        result.add(combiner.call(o1, o2));
                    }
                }
                return result;
            }
        }).flatMap(new Function1<List<V>, List<V>>(){

            @Override
            public List<V> call(List<V> input) {
                return input;
            }
        });
    }

    public <S1, S2, U1, U2, V> Domino<T, V> combineTask(TaskDomino<? super R, S1, U1> taskDomino1, TaskDomino<? super R, S2, U2> taskDomino2, Function2<? super S1, ? super S2, ? extends V> combiner) {
        return this.combine(taskDomino1.map(new Function1<Triple<Boolean, S1, U1>, S1>(){

            @Override
            public S1 call(Triple<Boolean, S1, U1> input) {
                return (Boolean)input.first != false ? (Object)input.second : null;
            }
        }), taskDomino2.map(new Function1<Triple<Boolean, S2, U2>, S2>(){

            @Override
            public S2 call(Triple<Boolean, S2, U2> input) {
                return (Boolean)input.first != false ? (Object)input.second : null;
            }
        }), combiner);
    }

    public Domino<T, R> background() {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                return new BackgroundScheduler(scheduler);
            }
        });
    }

    Domino<T, R> newThread() {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                return new NewThreadScheduler(scheduler);
            }
        });
    }

    Domino<T, R> defaultScheduler() {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                return new DefaultScheduler(scheduler);
            }
        });
    }

    public Domino<T, R> uiThread() {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                return new UiThreadScheduler(scheduler);
            }
        });
    }

    public Domino<T, R> backgroundQueue() {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                return new BackgroundQueueScheduler(scheduler);
            }
        });
    }

    public Domino<T, R> throttle(final long windowDuration, final TimeUnit unit) {
        return new Domino<T, R>(this.mLabel, new Player<T, R>(){

            @Override
            public Scheduler<R> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                return new ThrottleScheduler(scheduler, Domino.this.mLabel, windowDuration, unit);
            }
        });
    }

    public <U> Domino<T, U> lift(final Function1<CopyOnWriteArrayList<R>, CopyOnWriteArrayList<U>> function) {
        return new Domino<T, R>(this.mLabel, new Player<T, U>(){

            @Override
            public Scheduler<U> call(List<T> input) {
                Scheduler scheduler = Domino.this.mPlayer.call(input);
                return scheduler.scheduleFunction(Collections.singletonList(function));
            }
        });
    }

    public <U> Domino<T, U> map(Function1<? super R, ? extends U> map) {
        return this.lift(new MapOperator<R, U>(map));
    }

    public <U, S> Domino<T, U> map(Class<S> clazz, Function2<? super S, ? super R, ? extends U> map) {
        return this.lift(new MapOperator2<R, U, S>(clazz, map));
    }

    public <U> Domino<T, U> flatMap(Function1<? super R, List<U>> map) {
        return this.lift(new FlatMapOperator<R, U>(map));
    }

    public Domino<T, R> filter(Function1<? super R, Boolean> filter) {
        return this.lift(new FilterOperator<R>(filter));
    }

    public <U> Domino<T, U> reduce(Function1<List<R>, ? extends U> reducer) {
        return this.lift(new ReducerOperator<R, U>(reducer));
    }

    public <U> Domino<T, U> clear() {
        return this.lift(new EmptyOperator());
    }

    public <U, S> TaskDomino<T, U, S> beginTask(Task<R, U, S> task) {
        return new TaskDomino(this.map(new TaskFunction<R, U, S>(task)));
    }

    public void play(CopyOnWriteArrayList<T> input) {
        this.mPlayer.call((List<T>)input);
    }

    public void commit() {
        DOMINO_CENTER.commit(this);
    }

    private static class TaskFunction<T, R, U>
    implements Function1<T, Triple<Boolean, R, U>>,
    Task.TaskListener<R, U> {
        private Task<T, R, U> mTask;
        private volatile R mResult;
        private volatile U mError;
        private volatile int mFlag;
        private Lock mLock = new ReentrantLock();
        private Condition mCondition = this.mLock.newCondition();

        TaskFunction(Task<T, R, U> task) {
            task.setListener(this);
            this.mTask = task;
        }

        @Override
        public void onFailure(U error) {
            this.mLock.lock();
            this.mError = error;
            this.mFlag = 0;
            this.mCondition.signalAll();
            this.mLock.unlock();
        }

        @Override
        public void onSuccess(R result) {
            this.mLock.lock();
            this.mResult = result;
            this.mFlag = 1;
            this.mCondition.signalAll();
            this.mLock.unlock();
        }

        @Override
        public Triple<Boolean, R, U> call(T input) {
            this.mResult = null;
            this.mError = null;
            this.mFlag = -1;
            this.mTask.execute(input);
            try {
                this.mLock.lock();
                while (this.mFlag == -1) {
                    this.mCondition.await();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.mLock.unlock();
            }
            return new Triple<Boolean, R, U>(this.mFlag == 1, this.mResult, this.mError);
        }
    }
}

