/**
 *
 * Copyright 2016 Xiaofei
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package xiaofei.library.shelly.scheduler;

/**
 * Created by Xiaofei on 16/5/31.
 *
 * For unit test only.
 */
public class NewThreadScheduler<T> extends Scheduler<T> {

    public <R> NewThreadScheduler(Scheduler<R> scheduler) {
        super(scheduler);
    }

    @Override
    protected void onSchedule(Runnable runnable) {
        new Thread(runnable).start();
    }
}
