/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.shelly;

import java.util.List;
import xiaofei.library.shelly.action.Action0;
import xiaofei.library.shelly.action.Action1;
import xiaofei.library.shelly.action.TargetAction;
import xiaofei.library.shelly.internal.DominoCenter;
import xiaofei.library.shelly.internal.Player;
import xiaofei.library.shelly.internal.TargetCenter;
import xiaofei.library.shelly.scheduler.CachedThreadScheduler;
import xiaofei.library.shelly.scheduler.DefaultScheduler;
import xiaofei.library.shelly.scheduler.NewThreadScheduler;
import xiaofei.library.shelly.scheduler.Scheduler;
import xiaofei.library.shelly.scheduler.SingleThreadScheduler;
import xiaofei.library.shelly.scheduler.UiThreadScheduler;

public class Domino {
    private static final DominoCenter DOMINO_CENTER = DominoCenter.getInstance();
    private static final TargetCenter TARGET_CENTER = TargetCenter.getInstance();
    private Player mPlayer;
    private Object mLabel;

    public Domino(Object label) {
        this(label, new Player(){

            @Override
            public Scheduler play(Object input) {
                return new DefaultScheduler();
            }
        });
    }

    private Domino(Object label, Player player) {
        this.mLabel = label;
        this.mPlayer = player;
    }

    public Object getLabel() {
        return this.mLabel;
    }

    public Domino target(final Class<?> clazz, final String target) {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                final Scheduler scheduler = Domino.this.mPlayer.play(input);
                scheduler.play(new Player(){

                    @Override
                    public Scheduler play(Object input) {
                        TARGET_CENTER.call(clazz, target, input);
                        return scheduler;
                    }
                }, input);
                return scheduler;
            }
        });
    }

    public <T> Domino target(final Class<T> clazz, final TargetAction<T> targetAction) {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                final Scheduler scheduler = Domino.this.mPlayer.play(input);
                scheduler.play(new Player(){

                    @Override
                    public Scheduler play(Object input) {
                        List<Object> objects = TARGET_CENTER.getObjects(clazz);
                        for (Object object : objects) {
                            targetAction.call(object, input);
                        }
                        return scheduler;
                    }
                }, input);
                return scheduler;
            }
        });
    }

    public Domino target(final Action0 action0) {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                final Scheduler scheduler = Domino.this.mPlayer.play(input);
                scheduler.play(new Player(){

                    @Override
                    public Scheduler play(Object input) {
                        action0.call();
                        return scheduler;
                    }
                }, input);
                return scheduler;
            }
        });
    }

    public Domino target(final Action1 action1) {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                final Scheduler scheduler = Domino.this.mPlayer.play(input);
                scheduler.play(new Player(){

                    @Override
                    public Scheduler play(Object input) {
                        action1.call(input);
                        return scheduler;
                    }
                }, input);
                return scheduler;
            }
        });
    }

    public Domino cachedThread() {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                Domino.this.mPlayer.play(input);
                return new CachedThreadScheduler();
            }
        });
    }

    public Domino newThread() {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                Domino.this.mPlayer.play(input);
                return new NewThreadScheduler();
            }
        });
    }

    public Domino uiThread() {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                Domino.this.mPlayer.play(input);
                return new UiThreadScheduler();
            }
        });
    }

    public Domino singleThread() {
        return new Domino(this.mLabel, new Player(){

            @Override
            public Scheduler play(Object input) {
                Domino.this.mPlayer.play(input);
                return new SingleThreadScheduler();
            }
        });
    }

    public void play(Object input) {
        this.mPlayer.play(input);
    }

    public void commit() {
        DOMINO_CENTER.commit(this);
    }
}

