/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.internal;

import android.os.RemoteException;
import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import xiaofei.library.hermes.internal.CallbackMail;
import xiaofei.library.hermes.internal.IHermesServiceCallback;
import xiaofei.library.hermes.internal.Reply;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.MethodWrapper;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public class HermesCallbackInvocationHandler
implements InvocationHandler {
    private static final String TAG = "HERMES_CALLBACK";
    private long mTimeStamp;
    private int mIndex;
    private IHermesServiceCallback mCallback;

    public HermesCallbackInvocationHandler(long timeStamp, int index, IHermesServiceCallback callback) {
        this.mTimeStamp = timeStamp;
        this.mIndex = index;
        this.mCallback = callback;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) {
        try {
            MethodWrapper methodWrapper = new MethodWrapper(method);
            ParameterWrapper[] parameterWrappers = TypeUtils.objectToWrapper(objects);
            CallbackMail callbackMail = new CallbackMail(this.mTimeStamp, this.mIndex, methodWrapper, parameterWrappers);
            Reply reply = this.mCallback.callback(callbackMail);
            if (reply == null) {
                return null;
            }
            if (reply.success()) {
                return reply.getResult();
            }
            Log.e((String)TAG, (String)("Error occurs: " + reply.getMessage()));
            return null;
        }
        catch (HermesException e) {
            Log.e((String)TAG, (String)"Error occurs but does not crash the app.", (Throwable)e);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Error occurs but does not crash the app.", (Throwable)e);
        }
        return null;
    }
}

