/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.util;

import android.os.RemoteException;
import android.support.v4.util.Pair;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import xiaofei.library.hermes.internal.IHermesServiceCallback;
import xiaofei.library.hermes.util.Triple;

public class HermesCallbackGc {
    private static volatile HermesCallbackGc sInstance = null;
    private final ReferenceQueue<Object> mReferenceQueue = new ReferenceQueue();
    private final ConcurrentHashMap<PhantomReference<Object>, Triple<IHermesServiceCallback, Long, Integer>> mTimeStamps = new ConcurrentHashMap();

    private HermesCallbackGc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HermesCallbackGc getInstance() {
        if (sInstance != null) return sInstance;
        Class<HermesCallbackGc> clazz = HermesCallbackGc.class;
        synchronized (HermesCallbackGc.class) {
            if (sInstance != null) return sInstance;
            sInstance = new HermesCallbackGc();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gc() {
        ReferenceQueue<Object> referenceQueue = this.mReferenceQueue;
        synchronized (referenceQueue) {
            PhantomReference reference;
            HashMap timeStamps = new HashMap();
            while ((reference = (PhantomReference)this.mReferenceQueue.poll()) != null) {
                Triple<IHermesServiceCallback, Long, Integer> triple = this.mTimeStamps.remove(reference);
                if (triple == null) continue;
                Pair tmp = (Pair)timeStamps.get(triple.first);
                if (tmp == null) {
                    tmp = new Pair(new ArrayList(), new ArrayList());
                    timeStamps.put(triple.first, tmp);
                }
                ((ArrayList)tmp.first).add(triple.second);
                ((ArrayList)tmp.second).add(triple.third);
            }
            Set set = timeStamps.entrySet();
            for (Map.Entry entry : set) {
                Pair values = (Pair)entry.getValue();
                if (((ArrayList)values.first).isEmpty()) continue;
                try {
                    ((IHermesServiceCallback)entry.getKey()).gc((List)values.first, (List)values.second);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void register(IHermesServiceCallback callback, Object object, long timeStamp, int index) {
        this.gc();
        this.mTimeStamps.put(new PhantomReference<Object>(object, this.mReferenceQueue), Triple.create(callback, timeStamp, index));
    }
}

