/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.sender;

import android.content.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import xiaofei.library.hermes.HermesService;
import xiaofei.library.hermes.annotation.Background;
import xiaofei.library.hermes.annotation.WeakRef;
import xiaofei.library.hermes.internal.Channel;
import xiaofei.library.hermes.internal.Mail;
import xiaofei.library.hermes.internal.Reply;
import xiaofei.library.hermes.util.CallbackManager;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.TimeStampGenerator;
import xiaofei.library.hermes.util.TypeCenter;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.MethodWrapper;
import xiaofei.library.hermes.wrapper.ObjectWrapper;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public abstract class Sender {
    protected static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    private static final Channel CHANNEL = Channel.getInstance();
    private static final CallbackManager CALLBACK_MANAGER = CallbackManager.getInstance();
    private long mTimeStamp;
    private ObjectWrapper mObject;
    private MethodWrapper mMethod;
    private ParameterWrapper[] mParameters;
    private Class<? extends HermesService> mService;

    public Sender(Class<? extends HermesService> service, ObjectWrapper object) {
        this.mService = service;
        this.mObject = object;
    }

    protected abstract MethodWrapper getMethodWrapper(Method var1, ParameterWrapper[] var2) throws HermesException;

    protected void setParameterWrappers(ParameterWrapper[] parameterWrappers) {
        this.mParameters = parameterWrappers;
    }

    private void registerClass(Method method) throws HermesException {
        Class<?>[] classes;
        if (method == null) {
            return;
        }
        for (Class<?> clazz : classes = method.getParameterTypes()) {
            if (!clazz.isInterface()) continue;
            TYPE_CENTER.register(clazz);
            this.registerCallbackMethodParameterTypes(clazz);
        }
        TYPE_CENTER.register(method.getReturnType());
    }

    private void registerCallbackMethodParameterTypes(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] parameterTypes;
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                TYPE_CENTER.register(parameterType);
            }
        }
    }

    private final ParameterWrapper[] getParameterWrappers(Method method, Object[] parameters) throws HermesException {
        int length = parameters.length;
        ParameterWrapper[] parameterWrappers = new ParameterWrapper[length];
        if (method != null) {
            Class<?>[] classes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < length; ++i) {
                if (classes[i].isInterface()) {
                    Object parameter = parameters[i];
                    parameterWrappers[i] = parameter != null ? new ParameterWrapper(classes[i], null) : new ParameterWrapper((Object)null);
                    if (parameterAnnotations[i] == null || parameter == null) continue;
                    CALLBACK_MANAGER.addCallback(this.mTimeStamp, i, parameter, TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], WeakRef.class), !TypeUtils.arrayContainsAnnotation(parameterAnnotations[i], Background.class));
                    continue;
                }
                parameterWrappers[i] = Context.class.isAssignableFrom(classes[i]) ? new ParameterWrapper(TypeUtils.getContextClass(classes[i]), null) : new ParameterWrapper(parameters[i]);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                parameterWrappers[i] = new ParameterWrapper(parameters[i]);
            }
        }
        return parameterWrappers;
    }

    public final Reply send(Method method, Object[] parameters) throws HermesException {
        this.mTimeStamp = TimeStampGenerator.getTimeStamp();
        if (parameters == null) {
            parameters = new Object[]{};
        }
        ParameterWrapper[] parameterWrappers = this.getParameterWrappers(method, parameters);
        this.mMethod = this.getMethodWrapper(method, parameterWrappers);
        this.registerClass(method);
        this.setParameterWrappers(parameterWrappers);
        Mail mail = new Mail(this.mTimeStamp, this.mObject, this.mMethod, this.mParameters);
        return CHANNEL.send(this.mService, mail);
    }

    public ObjectWrapper getObject() {
        return this.mObject;
    }
}

