/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.internal;

import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import xiaofei.library.hermes.HermesService;
import xiaofei.library.hermes.internal.Reply;
import xiaofei.library.hermes.sender.Sender;
import xiaofei.library.hermes.sender.SenderDesignator;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.wrapper.ObjectWrapper;

public class HermesInvocationHandler
implements InvocationHandler {
    private static final String TAG = "HERMES_INVOCATION";
    private Sender mSender;

    public HermesInvocationHandler(Class<? extends HermesService> service, ObjectWrapper object) {
        this.mSender = SenderDesignator.getPostOffice(service, 3, object);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) {
        try {
            Reply reply = this.mSender.send(method, objects);
            if (reply == null) {
                return null;
            }
            if (reply.success()) {
                return reply.getResult();
            }
            Log.e((String)TAG, (String)("Error occurs. Error " + reply.getErrorCode() + ": " + reply.getMessage()));
            return null;
        }
        catch (HermesException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("Error occurs. Error " + e.getErrorCode() + ": " + e.getErrorMessage()));
            return null;
        }
    }
}

