/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.receiver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import xiaofei.library.hermes.receiver.Receiver;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.MethodWrapper;
import xiaofei.library.hermes.wrapper.ObjectWrapper;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public class InstanceCreatingReceiver
extends Receiver {
    private Class<?> mObjectClass;
    private Constructor<?> mConstructor;

    public InstanceCreatingReceiver(ObjectWrapper object) throws HermesException {
        super(object);
        Class<?> clazz = TYPE_CENTER.getClassType(object);
        TypeUtils.validateAccessible(clazz);
        this.mObjectClass = clazz;
    }

    @Override
    public void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws HermesException {
        Constructor<?> constructor = TypeUtils.getConstructor(this.mObjectClass, TYPE_CENTER.getClassTypes(parameterWrappers));
        TypeUtils.validateAccessible(constructor);
        this.mConstructor = constructor;
    }

    @Override
    protected Object invokeMethod() throws HermesException {
        ReflectiveOperationException exception;
        try {
            Object[] parameters = this.getParameters();
            Object object = parameters == null ? this.mConstructor.newInstance(new Object[0]) : this.mConstructor.newInstance(parameters);
            OBJECT_CENTER.putObject(this.getObjectTimeStamp(), object);
            return null;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        exception.printStackTrace();
        throw new HermesException(17, "Error occurs when invoking constructor to create an instance of " + this.mObjectClass.getName(), exception);
    }
}

