/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import xiaofei.library.hermes.HermesListener;
import xiaofei.library.hermes.HermesService;
import xiaofei.library.hermes.internal.Channel;
import xiaofei.library.hermes.internal.HermesInvocationHandler;
import xiaofei.library.hermes.internal.Reply;
import xiaofei.library.hermes.sender.Sender;
import xiaofei.library.hermes.sender.SenderDesignator;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.HermesGc;
import xiaofei.library.hermes.util.TypeCenter;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.ObjectWrapper;

public class Hermes {
    private static final String TAG = "HERMES";
    private static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    private static final Channel CHANNEL = Channel.getInstance();
    private static final HermesGc HERMES_GC = HermesGc.getInstance();
    private static Context sContext = null;

    public static void register(Object object) {
        Hermes.register(object.getClass());
    }

    private static void checkInit() {
        if (sContext == null) {
            throw new IllegalStateException("Hermes has not been initialized.");
        }
    }

    public static void register(Class<?> clazz) {
        Hermes.checkInit();
        TYPE_CENTER.register(clazz);
    }

    public static Context getContext() {
        return sContext;
    }

    public static void init(Context context) {
        if (sContext != null) {
            return;
        }
        sContext = context.getApplicationContext();
    }

    private static void checkBound(Class<? extends HermesService> service) {
        if (!CHANNEL.getBound(service)) {
            throw new IllegalStateException("Service Unavailable: You have not connected the service or the connection is not completed. You can set HermesListener to receive a callback when the connection is completed.");
        }
    }

    private static <T> T getProxy(Class<? extends HermesService> service, ObjectWrapper object) {
        Class<?> clazz = object.getObjectClass();
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new HermesInvocationHandler(service, object));
        HERMES_GC.register(service, proxy, object.getTimeStamp());
        return (T)proxy;
    }

    public static <T> T newInstance(Class<T> clazz, Object ... parameters) {
        return Hermes.newInstanceInService(HermesService.HermesService0.class, clazz, parameters);
    }

    public static <T> T newInstanceInService(Class<? extends HermesService> service, Class<T> clazz, Object ... parameters) {
        TypeUtils.validateServiceInterface(clazz);
        Hermes.checkBound(service);
        ObjectWrapper object = new ObjectWrapper(clazz, 0);
        Sender sender = SenderDesignator.getPostOffice(service, 0, object);
        try {
            Reply reply = sender.send(null, parameters);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during creating instance. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (HermesException e) {
            e.printStackTrace();
            return null;
        }
        object.setType(3);
        return Hermes.getProxy(service, object);
    }

    public static <T> T getInstanceInService(Class<? extends HermesService> service, Class<T> clazz, Object ... parameters) {
        return Hermes.getInstanceWithMethodNameInService(service, clazz, "", parameters);
    }

    public static <T> T getInstance(Class<T> clazz, Object ... parameters) {
        return Hermes.getInstanceInService(HermesService.HermesService0.class, clazz, parameters);
    }

    public static <T> T getInstanceWithMethodName(Class<T> clazz, String methodName, Object ... parameters) {
        return Hermes.getInstanceWithMethodNameInService(HermesService.HermesService0.class, clazz, methodName, parameters);
    }

    public static <T> T getInstanceWithMethodNameInService(Class<? extends HermesService> service, Class<T> clazz, String methodName, Object ... parameters) {
        TypeUtils.validateServiceInterface(clazz);
        Hermes.checkBound(service);
        ObjectWrapper object = new ObjectWrapper(clazz, 1);
        Sender sender = SenderDesignator.getPostOffice(service, 1, object);
        if (parameters == null) {
            parameters = new Object[]{};
        }
        int length = parameters.length;
        Object[] tmp = new Object[length + 1];
        tmp[0] = methodName;
        for (int i = 0; i < length; ++i) {
            tmp[i + 1] = parameters[i];
        }
        try {
            Reply reply = sender.send(null, tmp);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during getting instance. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (HermesException e) {
            e.printStackTrace();
            return null;
        }
        object.setType(3);
        return Hermes.getProxy(service, object);
    }

    public static <T> T getUtilityClass(Class<T> clazz) {
        return Hermes.getUtilityClassInService(HermesService.HermesService0.class, clazz);
    }

    public static <T> T getUtilityClassInService(Class<? extends HermesService> service, Class<T> clazz) {
        TypeUtils.validateServiceInterface(clazz);
        Hermes.checkBound(service);
        ObjectWrapper object = new ObjectWrapper(clazz, 5);
        Sender sender = SenderDesignator.getPostOffice(service, 2, object);
        try {
            Reply reply = sender.send(null, null);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during getting utility class. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (HermesException e) {
            e.printStackTrace();
            return null;
        }
        object.setType(4);
        return Hermes.getProxy(service, object);
    }

    public static void connect(Context context) {
        Hermes.connect(context, HermesService.HermesService0.class);
    }

    public static void connect(Context context, Class<? extends HermesService> service) {
        Hermes.connectApp(context, null, service);
    }

    public static void connectApp(Context context, String packageName) {
        Hermes.connectApp(context, packageName, HermesService.HermesService0.class);
    }

    public static void connectApp(Context context, String packageName, Class<? extends HermesService> service) {
        CHANNEL.bind(context.getApplicationContext(), packageName, service);
    }

    public static void disconnect(Context context) {
        Hermes.disconnect(context, HermesService.HermesService0.class);
    }

    public static void disconnect(Context context, Class<? extends HermesService> service) {
        CHANNEL.unbind(context.getApplicationContext(), service);
    }

    public static boolean isConnected() {
        return Hermes.isConnected(HermesService.HermesService0.class);
    }

    public static boolean isConnected(Class<? extends HermesService> service) {
        return CHANNEL.isConnected(service);
    }

    public static void setHermesListener(HermesListener listener) {
        CHANNEL.setHermesListener(listener);
    }
}

