/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.util;

import android.app.Activity;
import android.app.Application;
import android.app.IntentService;
import android.app.Service;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.AppCompatActivity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import xiaofei.library.hermes.annotation.ClassId;
import xiaofei.library.hermes.annotation.GetInstance;
import xiaofei.library.hermes.annotation.MethodId;
import xiaofei.library.hermes.annotation.WithinProcess;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public class TypeUtils {
    private static final HashSet<Class<?>> CONTEXT_CLASSES = new HashSet<Class<?>>(){
        {
            this.add(Context.class);
            this.add(ActionBarActivity.class);
            this.add(Activity.class);
            this.add(AppCompatActivity.class);
            this.add(Application.class);
            this.add(FragmentActivity.class);
            this.add(IntentService.class);
            this.add(Service.class);
        }
    };

    public static String getClassId(Class<?> clazz) {
        ClassId classId = clazz.getAnnotation(ClassId.class);
        if (classId != null) {
            return classId.value();
        }
        return clazz.getName();
    }

    public static String getMethodId(Method method) {
        MethodId methodId = method.getAnnotation(MethodId.class);
        if (methodId != null) {
            return methodId.value();
        }
        StringBuilder result = new StringBuilder(method.getName());
        result.append('(').append(TypeUtils.getMethodParameters(method.getParameterTypes())).append(')');
        return result.toString();
    }

    private static String getClassName(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return "boolean";
        }
        if (clazz == Byte.class) {
            return "byte";
        }
        if (clazz == Character.class) {
            return "char";
        }
        if (clazz == Short.class) {
            return "short";
        }
        if (clazz == Integer.class) {
            return "int";
        }
        if (clazz == Long.class) {
            return "long";
        }
        if (clazz == Float.class) {
            return "float";
        }
        if (clazz == Double.class) {
            return "double";
        }
        if (clazz == Void.class) {
            return "void";
        }
        return clazz.getName();
    }

    public static String getMethodParameters(Class<?>[] classes) {
        StringBuilder result = new StringBuilder();
        int length = classes.length;
        if (length == 0) {
            return result.toString();
        }
        result.append(TypeUtils.getClassName(classes[0]));
        for (int i = 1; i < length; ++i) {
            result.append(",").append(TypeUtils.getClassName(classes[i]));
        }
        return result.toString();
    }

    public static boolean primitiveMatch(Class<?> class1, Class<?> class2) {
        if (!class1.isPrimitive() && !class2.isPrimitive()) {
            return false;
        }
        if (class1 == class2) {
            return true;
        }
        if (class1.isPrimitive()) {
            return TypeUtils.primitiveMatch(class2, class1);
        }
        if (class1 == Boolean.class && class2 == Boolean.TYPE) {
            return true;
        }
        if (class1 == Byte.class && class2 == Byte.TYPE) {
            return true;
        }
        if (class1 == Character.class && class2 == Character.TYPE) {
            return true;
        }
        if (class1 == Short.class && class2 == Short.TYPE) {
            return true;
        }
        if (class1 == Integer.class && class2 == Integer.TYPE) {
            return true;
        }
        if (class1 == Long.class && class2 == Long.TYPE) {
            return true;
        }
        if (class1 == Float.class && class2 == Float.TYPE) {
            return true;
        }
        if (class1 == Double.class && class2 == Double.TYPE) {
            return true;
        }
        return class1 == Void.class && class2 == Void.TYPE;
    }

    public static boolean match(Class<?>[] classes1, Class<?>[] classes2) {
        if (classes1.length != classes2.length) {
            return false;
        }
        int length = classes2.length;
        for (int i = 0; i < length; ++i) {
            if (classes2[i] == null || TypeUtils.primitiveMatch(classes1[i], classes2[i]) || classes1[i].isAssignableFrom(classes2[i])) continue;
            return false;
        }
        return true;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<?> returnType) throws HermesException {
        Method[] methods;
        Method result = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !TypeUtils.match(method.getParameterTypes(), parameterTypes)) continue;
            if (result == null) {
                result = method;
                continue;
            }
            throw new HermesException(8, "There are more than one method named " + methodName + " of the class " + clazz.getName() + " matching the parameters!");
        }
        if (result == null) {
            return result;
        }
        if (result.getReturnType() != returnType) {
            throw new HermesException(9, "The method named " + methodName + " of the class " + clazz.getName() + " matches the parameter types but not the return type. The return type is " + result.getReturnType().getName() + " but the required type is " + returnType.getName() + ". The method in the local interface must exactly " + "match the method in the remote class.");
        }
        return result;
    }

    public static Method getMethodForGettingInstance(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws HermesException {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (Method method : methods) {
            String tmpName = method.getName();
            if ((!methodName.equals("") || !tmpName.equals("getInstance") && !method.isAnnotationPresent(GetInstance.class)) && (methodName.equals("") || !tmpName.equals(methodName)) || !TypeUtils.match(method.getParameterTypes(), parameterTypes)) continue;
            if (result == null) {
                result = method;
                continue;
            }
            throw new HermesException(10, "When getting instance, there are more than one method named " + methodName + " of the class " + clazz.getName() + " matching the parameters!");
        }
        if (result != null) {
            if (result.getReturnType() != clazz) {
                throw new HermesException(11, "When getting instance, the method named " + methodName + " of the class " + clazz.getName() + " matches the parameter types but not the return type. The return type is " + result.getReturnType().getName() + " but the required type is " + clazz.getName() + ".");
            }
            return result;
        }
        throw new HermesException(12, "When getting instance, the method named " + methodName + " of the class " + clazz.getName() + " is not found. The class must have a method for getting instance.");
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] parameterTypes) throws HermesException {
        Constructor<?>[] constructors;
        Constructor<?> result = null;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (!TypeUtils.match(constructor.getParameterTypes(), parameterTypes)) continue;
            if (result != null) {
                throw new HermesException(13, "The class " + clazz.getName() + " has too many constructors whose " + " parameter types match the required types.");
            }
            result = constructor;
        }
        if (result == null) {
            throw new HermesException(14, "The class " + clazz.getName() + " do not have a constructor whose " + " parameter types match the required types.");
        }
        return result;
    }

    public static ParameterWrapper[] objectToWrapper(Object[] objects) throws HermesException {
        if (objects == null) {
            objects = new Object[]{};
        }
        int length = objects.length;
        ParameterWrapper[] parameterWrappers = new ParameterWrapper[length];
        for (int i = 0; i < length; ++i) {
            try {
                parameterWrappers[i] = new ParameterWrapper(objects[i]);
                continue;
            }
            catch (HermesException e) {
                e.printStackTrace();
                throw new HermesException(e.getErrorCode(), "Error happens at parameter encoding, and parameter index is " + i + ". See the stack trace for more information.", e);
            }
        }
        return parameterWrappers;
    }

    public static void validateClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class object is null.");
        }
        if (clazz.isPrimitive() || clazz.isInterface()) {
            return;
        }
        if (clazz.isAnnotationPresent(WithinProcess.class)) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Class with a WithinProcess annotation presented on it cannot be accessed" + " from outside the process.");
        }
        if (clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Anonymous class cannot be accessed from outside the process.");
        }
        if (clazz.isLocalClass()) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Local class cannot be accessed from outside the process.");
        }
        if (Context.class.isAssignableFrom(clazz)) {
            return;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Error occurs when registering class " + clazz.getName() + ". Abstract class cannot be accessed from outside the process.");
        }
    }

    public static void validateServiceInterface(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class object is null.");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Only interfaces can be passed as the parameters.");
        }
    }

    public static boolean arrayContainsAnnotation(Annotation[] annotations, Class<? extends Annotation> annotationClass) {
        if (annotations == null || annotationClass == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getContextClass(Class<?> clazz) {
        for (Class<?> tmp = clazz; tmp != Object.class; tmp = tmp.getSuperclass()) {
            if (!CONTEXT_CLASSES.contains(tmp)) continue;
            return tmp;
        }
        throw new IllegalArgumentException();
    }

    public static void validateAccessible(Class<?> clazz) throws HermesException {
        if (clazz.isAnnotationPresent(WithinProcess.class)) {
            throw new HermesException(18, "Class " + clazz.getName() + " has a WithProcess annotation on it, " + "so it cannot be accessed from outside the process.");
        }
    }

    public static void validateAccessible(Method method) throws HermesException {
        if (method.isAnnotationPresent(WithinProcess.class)) {
            throw new HermesException(19, "Method " + method.getName() + " of class " + method.getDeclaringClass().getName() + " has a WithProcess annotation on it, so it cannot be accessed from " + "outside the process.");
        }
    }

    public static void validateAccessible(Constructor<?> constructor) throws HermesException {
        if (constructor.isAnnotationPresent(WithinProcess.class)) {
            throw new HermesException(19, "Constructor " + constructor.getName() + " of class " + constructor.getDeclaringClass().getName() + " has a WithProcess annotation on it, so it cannot be accessed from " + "outside the process.");
        }
    }
}

