/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.receiver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import xiaofei.library.hermes.receiver.Receiver;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.MethodWrapper;
import xiaofei.library.hermes.wrapper.ObjectWrapper;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public class ObjectReceiver
extends Receiver {
    private Method mMethod;
    private Object mObject = OBJECT_CENTER.getObject(this.getObjectTimeStamp());

    public ObjectReceiver(ObjectWrapper objectWrapper) {
        super(objectWrapper);
    }

    @Override
    public void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws HermesException {
        Method method = TYPE_CENTER.getMethod(this.mObject.getClass(), methodWrapper);
        TypeUtils.validateAccessible(method);
        this.mMethod = method;
    }

    @Override
    protected Object invokeMethod() throws HermesException {
        ReflectiveOperationException exception;
        try {
            return this.mMethod.invoke(this.mObject, this.getParameters());
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        exception.printStackTrace();
        throw new HermesException(17, "Error occurs when invoking method " + this.mMethod + " on " + this.mObject, exception);
    }
}

