/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.util;

import java.lang.constant.Constable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import xiaofei.library.hermes.HermesService;
import xiaofei.library.hermes.internal.Channel;

public class HermesGc {
    private static HermesGc sInstance = null;
    private ReferenceQueue<Object> mReferenceQueue = new ReferenceQueue();
    private static final Channel CHANNEL = Channel.getInstance();
    private HashMap<PhantomReference<Object>, Long> mTimeStamps = new HashMap();
    private HashMap<Long, Class<? extends HermesService>> mServices = new HashMap();

    private HermesGc() {
    }

    public static synchronized HermesGc getInstance() {
        if (sInstance == null) {
            sInstance = new HermesGc();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gc() {
        ReferenceQueue<Object> referenceQueue = this.mReferenceQueue;
        synchronized (referenceQueue) {
            Reference<Object> reference;
            HashMap<Class<? extends HermesService>, ArrayList<Long>> timeStamps = new HashMap<Class<? extends HermesService>, ArrayList<Long>>();
            while ((reference = this.mReferenceQueue.poll()) != null) {
                Class<? extends HermesService> clazz;
                Long timeStamp;
                HashMap<PhantomReference<Object>, Long> hashMap = this.mTimeStamps;
                synchronized (hashMap) {
                    timeStamp = this.mTimeStamps.remove(reference);
                }
                if (timeStamp == null || (clazz = this.mServices.remove(timeStamp)) == null) continue;
                ArrayList<Long> tmp = (ArrayList<Long>)timeStamps.get(timeStamp);
                if (tmp == null) {
                    tmp = new ArrayList<Long>();
                    timeStamps.put(clazz, tmp);
                }
                tmp.add(timeStamp);
            }
            Set set = timeStamps.entrySet();
            for (Map.Entry entry : set) {
                ArrayList values = (ArrayList)entry.getValue();
                if (values.isEmpty()) continue;
                CHANNEL.gc((Class)entry.getKey(), values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<? extends HermesService> service, Object object, Long timeStamp) {
        this.gc();
        HashMap<Object, Constable> hashMap = this.mTimeStamps;
        synchronized (hashMap) {
            this.mTimeStamps.put(new PhantomReference<Object>(object, this.mReferenceQueue), timeStamp);
        }
        hashMap = this.mServices;
        synchronized (hashMap) {
            this.mServices.put(timeStamp, service);
        }
    }
}

