/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.util;

import android.text.TextUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import xiaofei.library.hermes.annotation.ClassId;
import xiaofei.library.hermes.annotation.MethodId;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.BaseWrapper;
import xiaofei.library.hermes.wrapper.MethodWrapper;

public class TypeCenter {
    private static TypeCenter sInstance = null;
    private HashMap<String, Class<?>> mAnnotatedClasses = new HashMap();
    private HashMap<String, Class<?>> mRawClasses = new HashMap();
    private HashMap<Class<?>, HashMap<String, Method>> mAnnotatedMethods = new HashMap();
    private HashMap<Class<?>, HashMap<String, Method>> mRawMethods = new HashMap();

    private TypeCenter() {
    }

    public static synchronized TypeCenter getInstance() {
        if (sInstance == null) {
            sInstance = new TypeCenter();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerClass(Class<?> clazz) {
        ClassId classId = clazz.getAnnotation(ClassId.class);
        if (classId == null) {
            HashMap<String, Class<?>> hashMap = this.mRawClasses;
            synchronized (hashMap) {
                String className = clazz.getName();
                if (!this.mRawMethods.containsKey(className)) {
                    this.mRawClasses.put(className, clazz);
                }
            }
        }
        HashMap<String, Class<?>> hashMap = this.mAnnotatedClasses;
        synchronized (hashMap) {
            String className = classId.value();
            if (!this.mAnnotatedClasses.containsKey(className)) {
                this.mAnnotatedClasses.put(className, clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMethod(Class<?> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String key;
            HashMap<String, Method> map;
            HashMap<Class<?>, HashMap<String, Method>> hashMap;
            MethodId methodId = method.getAnnotation(MethodId.class);
            if (methodId == null) {
                hashMap = this.mRawMethods;
                synchronized (hashMap) {
                    if (!this.mRawMethods.containsKey(clazz)) {
                        this.mRawMethods.put(clazz, new HashMap());
                    }
                    map = this.mRawMethods.get(clazz);
                    key = TypeUtils.getMethodId(method);
                    map.put(key, method);
                    continue;
                }
            }
            hashMap = this.mAnnotatedMethods;
            synchronized (hashMap) {
                if (!this.mAnnotatedMethods.containsKey(clazz)) {
                    this.mAnnotatedMethods.put(clazz, new HashMap());
                }
                map = this.mAnnotatedMethods.get(clazz);
                key = TypeUtils.getMethodId(method);
                map.put(key, method);
            }
        }
    }

    public void register(Class<?> clazz) {
        TypeUtils.validateClass(clazz);
        this.registerClass(clazz);
        this.registerMethod(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassType(BaseWrapper wrapper) throws HermesException {
        Class<?> clazz;
        String name = wrapper.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (wrapper.isName()) {
            Class<Object> clazz2;
            HashMap<String, Class<?>> hashMap = this.mRawClasses;
            synchronized (hashMap) {
                clazz2 = this.mRawClasses.get(name);
            }
            if (clazz2 != null) {
                return clazz2;
            }
            if (name.equals("boolean")) {
                clazz2 = Boolean.TYPE;
            } else if (name.equals("byte")) {
                clazz2 = Byte.TYPE;
            } else if (name.equals("char")) {
                clazz2 = Character.TYPE;
            } else if (name.equals("short")) {
                clazz2 = Short.TYPE;
            } else if (name.equals("int")) {
                clazz2 = Integer.TYPE;
            } else if (name.equals("long")) {
                clazz2 = Long.TYPE;
            } else if (name.equals("float")) {
                clazz2 = Float.TYPE;
            } else if (name.equals("double")) {
                clazz2 = Double.TYPE;
            } else if (name.equals("void")) {
                clazz2 = Void.TYPE;
            } else {
                try {
                    clazz2 = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw new HermesException(15, "Cannot find class " + name + ". Classes without ClassId annotation on it " + "should be located at the same package and have the same name, " + "EVEN IF the source code has been obfuscated by Proguard.");
                }
            }
            hashMap = this.mRawClasses;
            synchronized (hashMap) {
                this.mRawClasses.put(name, clazz2);
            }
            return clazz2;
        }
        HashMap<String, Class<?>> hashMap = this.mAnnotatedClasses;
        synchronized (hashMap) {
            clazz = this.mAnnotatedClasses.get(name);
        }
        if (clazz == null) {
            throw new HermesException(15, "Cannot find class with ClassId annotation on it. ClassId = " + name + ". Please add the same annotation on the corresponding class in the remote process" + " and register it. Have you forgotten to register the class?");
        }
        return clazz;
    }

    public Class<?>[] getClassTypes(BaseWrapper[] wrappers) throws HermesException {
        Class[] classes = new Class[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            classes[i] = this.getClassType(wrappers[i]);
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class<?> clazz, MethodWrapper methodWrapper) throws HermesException {
        HashMap<String, Method> methods;
        String name = methodWrapper.getName();
        if (methodWrapper.isName()) {
            Method method;
            Class<?> returnType = this.getClassType(methodWrapper.getReturnType());
            HashMap<Class<?>, HashMap<String, Method>> hashMap = this.mRawMethods;
            synchronized (hashMap) {
                if (!this.mRawMethods.containsKey(clazz)) {
                    this.mRawMethods.put(clazz, new HashMap());
                }
                method = this.mRawMethods.get(clazz).get(name);
            }
            if (method != null) {
                Class<?> tmp = method.getReturnType();
                if (TypeUtils.primitiveMatch(tmp, returnType)) {
                    return method;
                }
                if (tmp != returnType) {
                    throw new HermesException(16, "The return type of methods do not match. Method " + method + " return type: " + tmp.getName() + ". The required is " + returnType.getName());
                }
                return method;
            }
            int pos = name.indexOf(40);
            method = TypeUtils.getMethod(clazz, name.substring(0, pos), this.getClassTypes(methodWrapper.getParameterTypes()), this.getClassType(methodWrapper.getReturnType()));
            if (method == null) {
                throw new HermesException(16, "Method not found: " + name + " in class " + clazz.getName());
            }
            this.mRawMethods.get(clazz).put(name, method);
            return method;
        }
        Object method = this.mAnnotatedMethods;
        synchronized (method) {
            methods = this.mAnnotatedMethods.get(clazz);
        }
        method = methods.get(name);
        if (method != null) {
            return method;
        }
        throw new HermesException(16, "Method not found in class " + clazz.getName() + ". Method id = " + name + ". " + "Please add the same annotation on the corresponding method in the remote process.");
    }
}

