/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.receiver;

import android.content.Context;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import xiaofei.library.hermes.Hermes;
import xiaofei.library.hermes.internal.HermesCallbackInvocationHandler;
import xiaofei.library.hermes.internal.IHermesServiceCallback;
import xiaofei.library.hermes.internal.Reply;
import xiaofei.library.hermes.util.CodeUtils;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.ObjectCenter;
import xiaofei.library.hermes.util.TypeCenter;
import xiaofei.library.hermes.wrapper.MethodWrapper;
import xiaofei.library.hermes.wrapper.ObjectWrapper;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public abstract class Receiver {
    protected static final ObjectCenter OBJECT_CENTER = ObjectCenter.getInstance();
    protected static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    private long mObjectTimeStamp;
    private Object[] mParameters;
    private IHermesServiceCallback mCallback;

    public Receiver(ObjectWrapper objectWrapper) {
        this.mObjectTimeStamp = objectWrapper.getTimeStamp();
    }

    protected long getObjectTimeStamp() {
        return this.mObjectTimeStamp;
    }

    protected Object[] getParameters() {
        return this.mParameters;
    }

    public void setHermesServiceCallback(IHermesServiceCallback callback) {
        this.mCallback = callback;
    }

    private Object getProxy(Class<?> clazz, int index, long methodInvocationTimeStamp) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new HermesCallbackInvocationHandler(methodInvocationTimeStamp, index, this.mCallback));
    }

    private final void setParameters(long methodInvocationTimeStamp, ParameterWrapper[] parameterWrappers) throws HermesException {
        if (parameterWrappers == null) {
            this.mParameters = null;
        } else {
            int length = parameterWrappers.length;
            this.mParameters = new Object[length];
            for (int i = 0; i < length; ++i) {
                String data;
                Class<?> clazz;
                ParameterWrapper parameterWrapper = parameterWrappers[i];
                this.mParameters[i] = parameterWrapper == null ? null : ((clazz = TYPE_CENTER.getClassType(parameterWrapper)) != null && clazz.isInterface() ? this.getProxy(clazz, i, methodInvocationTimeStamp) : (clazz != null && Context.class.isAssignableFrom(clazz) ? Hermes.getContext() : ((data = parameterWrapper.getData()) == null ? null : CodeUtils.decode(data, clazz))));
            }
        }
    }

    protected abstract void setMethod(MethodWrapper var1, ParameterWrapper[] var2) throws HermesException;

    protected abstract Object invokeMethod() throws HermesException;

    public final Reply action(long methodInvocationTimeStamp, MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws HermesException {
        this.setMethod(methodWrapper, parameterWrappers);
        this.setParameters(methodInvocationTimeStamp, parameterWrappers);
        Object result = this.invokeMethod();
        if (result == null) {
            return null;
        }
        return new Reply(new ParameterWrapper(result));
    }
}

