/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.support.v4.util.Pair;
import android.util.Log;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import xiaofei.library.hermes.HermesListener;
import xiaofei.library.hermes.HermesService;
import xiaofei.library.hermes.internal.CallbackMail;
import xiaofei.library.hermes.internal.IHermesService;
import xiaofei.library.hermes.internal.IHermesServiceCallback;
import xiaofei.library.hermes.internal.Mail;
import xiaofei.library.hermes.internal.Reply;
import xiaofei.library.hermes.util.CallbackManager;
import xiaofei.library.hermes.util.CodeUtils;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.TypeCenter;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public class Channel {
    private static final String TAG = "Channel";
    private static Channel sInstance = null;
    private HashMap<Class<? extends HermesService>, IHermesService> mHermesServices = new HashMap();
    private HashMap<Class<? extends HermesService>, HermesServiceConnection> mHermesServiceConnections = new HashMap();
    private HashMap<Class<? extends HermesService>, Boolean> mBindings = new HashMap();
    private HashMap<Class<? extends HermesService>, Boolean> mBounds = new HashMap();
    private HermesListener mListener = null;
    private Handler mUiHandler = new Handler(Looper.getMainLooper());
    private static final CallbackManager CALLBACK_MANAGER = CallbackManager.getInstance();
    private static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    private IHermesServiceCallback mHermesServiceCallback = new IHermesServiceCallback.Stub(){

        private Object[] getParameters(ParameterWrapper[] parameterWrappers) throws HermesException {
            if (parameterWrappers == null) {
                parameterWrappers = new ParameterWrapper[]{};
            }
            int length = parameterWrappers.length;
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                ParameterWrapper parameterWrapper = parameterWrappers[i];
                if (parameterWrapper == null) {
                    result[i] = null;
                    continue;
                }
                Class<?> clazz = TYPE_CENTER.getClassType(parameterWrapper);
                String data = parameterWrapper.getData();
                result[i] = data == null ? null : CodeUtils.decode(data, clazz);
            }
            return result;
        }

        @Override
        public Reply callback(CallbackMail mail) {
            Pair<Boolean, Object> pair = CALLBACK_MANAGER.getCallback(mail.getTimeStamp(), mail.getIndex());
            if (pair == null) {
                return null;
            }
            final Object callback = pair.second;
            if (callback == null) {
                return new Reply(21, "");
            }
            boolean uiThread = (Boolean)pair.first;
            try {
                final Method method = TYPE_CENTER.getMethod(callback.getClass(), mail.getMethod());
                final Object[] parameters = this.getParameters(mail.getParameters());
                if (uiThread) {
                    Channel.this.mUiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                method.invoke(callback, parameters);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    return null;
                }
                Object result = method.invoke(callback, parameters);
                if (result == null) {
                    return null;
                }
                return new Reply(new ParameterWrapper(result));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    };

    private Channel() {
    }

    public static synchronized Channel getInstance() {
        if (sInstance == null) {
            sInstance = new Channel();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Context context, Class<? extends HermesService> service) {
        Serializable binding;
        HashMap<Class<? extends HermesService>, Boolean> hashMap = this.mBounds;
        synchronized (hashMap) {
            Boolean bound = this.mBounds.get(service);
            if (bound != null && bound.booleanValue()) {
                return;
            }
        }
        hashMap = this.mBindings;
        synchronized (hashMap) {
            binding = this.mBindings.get(service);
            if (binding != null && binding.booleanValue()) {
                return;
            }
            this.mBindings.put(service, true);
        }
        HermesServiceConnection connection = new HermesServiceConnection(service);
        binding = this.mHermesServiceConnections;
        synchronized (binding) {
            this.mHermesServiceConnections.put(service, connection);
        }
        Intent intent = new Intent(context, service);
        context.bindService(intent, (ServiceConnection)connection, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(Context context, Class<? extends HermesService> service) {
        HashMap<Class<? extends HermesService>, Boolean> hashMap = this.mBounds;
        synchronized (hashMap) {
            Boolean bound = this.mBounds.get(service);
            if (bound != null && bound.booleanValue()) {
                HashMap<Class<? extends HermesService>, HermesServiceConnection> hashMap2 = this.mHermesServiceConnections;
                synchronized (hashMap2) {
                    HermesServiceConnection connection = this.mHermesServiceConnections.get(service);
                    if (connection != null) {
                        context.unbindService((ServiceConnection)connection);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply send(Class<? extends HermesService> service, Mail mail) {
        IHermesService hermesService;
        HashMap<Class<? extends HermesService>, IHermesService> hashMap = this.mHermesServices;
        synchronized (hashMap) {
            hermesService = this.mHermesServices.get(service);
        }
        try {
            if (hermesService == null) {
                return new Reply(2, "Service Unavailable: Check whether you have init Hermes.");
            }
            return hermesService.send(mail);
        }
        catch (RemoteException e) {
            return new Reply(1, "Remote Exception: Check whether the process you are communicating with is still alive.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc(Class<? extends HermesService> service, List<Long> timeStamps) {
        IHermesService hermesService;
        HashMap<Class<? extends HermesService>, IHermesService> hashMap = this.mHermesServices;
        synchronized (hashMap) {
            hermesService = this.mHermesServices.get(service);
        }
        try {
            hermesService.gc(timeStamps);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setHermesListener(HermesListener listener) {
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected(Class<? extends HermesService> service) {
        IHermesService hermesService;
        HashMap<Class<? extends HermesService>, IHermesService> hashMap = this.mHermesServices;
        synchronized (hashMap) {
            hermesService = this.mHermesServices.get(service);
        }
        if (hermesService == null) {
            return false;
        }
        return hermesService.asBinder().pingBinder();
    }

    private class HermesServiceConnection
    implements ServiceConnection {
        private Class<? extends HermesService> mClass;

        HermesServiceConnection(Class<? extends HermesService> service) {
            this.mClass = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            HashMap hashMap = Channel.this.mBounds;
            synchronized (hashMap) {
                Channel.this.mBounds.put(this.mClass, true);
            }
            hashMap = Channel.this.mBindings;
            synchronized (hashMap) {
                Channel.this.mBindings.put(this.mClass, false);
            }
            IHermesService hermesService = IHermesService.Stub.asInterface(service);
            HashMap hashMap2 = Channel.this.mHermesServices;
            synchronized (hashMap2) {
                Channel.this.mHermesServices.put(this.mClass, hermesService);
            }
            try {
                hermesService.register(Channel.this.mHermesServiceCallback, Process.myPid());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                Log.e((String)Channel.TAG, (String)"Remote Exception: Check whether the process you are communicating with is still alive.");
                return;
            }
            if (Channel.this.mListener != null) {
                Channel.this.mListener.onInitSuccess(this.mClass);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Channel.this.mHermesServices = null;
            HashMap hashMap = Channel.this.mBounds;
            synchronized (hashMap) {
                Channel.this.mBounds.put(this.mClass, false);
            }
            hashMap = Channel.this.mBindings;
            synchronized (hashMap) {
                Channel.this.mBindings.put(this.mClass, false);
            }
            if (Channel.this.mListener != null) {
                Channel.this.mListener.onDisconnected(this.mClass);
            }
        }
    }
}

