/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import xiaofei.library.hermes.HermesListener;
import xiaofei.library.hermes.HermesService;
import xiaofei.library.hermes.internal.Channel;
import xiaofei.library.hermes.internal.HermesInvocationHandler;
import xiaofei.library.hermes.internal.Reply;
import xiaofei.library.hermes.sender.Sender;
import xiaofei.library.hermes.sender.SenderDesignator;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.HermesGc;
import xiaofei.library.hermes.util.TypeCenter;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.ObjectWrapper;

public class Hermes {
    private static final String TAG = "HERMES";
    private static final TypeCenter TYPE_CENTER = TypeCenter.getInstance();
    private static final Channel CHANNEL = Channel.getInstance();
    private static final HermesGc HERMES_GC = HermesGc.getInstance();
    private static volatile Context sContext = null;

    public static void register(Object object) {
        Hermes.register(object.getClass());
    }

    public static void register(Class<?> clazz) {
        TYPE_CENTER.register(clazz);
    }

    public static Context getContext() {
        return sContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContext(Context context) {
        Class<Hermes> clazz = Hermes.class;
        synchronized (Hermes.class) {
            if (sContext == null) {
                sContext = context.getApplicationContext();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static <T> T getProxy(Class<? extends HermesService> service, ObjectWrapper object) {
        Class<?> clazz = object.getObjectClass();
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new HermesInvocationHandler(service, object));
        HERMES_GC.register(service, proxy, object.getTimeStamp());
        return (T)proxy;
    }

    public static <T> T newInstance(Class<T> clazz, Object ... parameters) {
        return Hermes.newInstanceInService(HermesService.HermesService0.class, clazz, parameters);
    }

    public static <T> T newInstanceInService(Class<? extends HermesService> service, Class<T> clazz, Object ... parameters) {
        TypeUtils.validateServiceInterface(clazz);
        ObjectWrapper object = new ObjectWrapper(clazz, 0);
        Sender sender = SenderDesignator.getPostOffice(service, 0, object);
        try {
            Reply reply = sender.send(null, parameters);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during creating instance. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (HermesException e) {
            e.printStackTrace();
            return null;
        }
        object.setType(3);
        return Hermes.getProxy(service, object);
    }

    public static <T> T getInstanceInService(Class<? extends HermesService> service, Class<T> clazz, Object ... parameters) {
        return Hermes.getInstanceWithMethodNameInService(service, clazz, "", parameters);
    }

    public static <T> T getInstance(Class<T> clazz, Object ... parameters) {
        return Hermes.getInstanceInService(HermesService.HermesService0.class, clazz, parameters);
    }

    public static <T> T getInstanceWithMethodName(Class<T> clazz, String methodName, Object ... parameters) {
        return Hermes.getInstanceWithMethodNameInService(HermesService.HermesService0.class, clazz, methodName, parameters);
    }

    public static <T> T getInstanceWithMethodNameInService(Class<? extends HermesService> service, Class<T> clazz, String methodName, Object ... parameters) {
        TypeUtils.validateServiceInterface(clazz);
        ObjectWrapper object = new ObjectWrapper(clazz, 1);
        Sender sender = SenderDesignator.getPostOffice(service, 1, object);
        if (parameters == null) {
            parameters = new Object[]{};
        }
        int length = parameters.length;
        Object[] tmp = new Object[length + 1];
        tmp[0] = methodName;
        for (int i = 0; i < length; ++i) {
            tmp[i + 1] = parameters[i];
        }
        try {
            Reply reply = sender.send(null, tmp);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during getting instance. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (HermesException e) {
            e.printStackTrace();
            return null;
        }
        object.setType(3);
        return Hermes.getProxy(service, object);
    }

    public static <T> T getUtilityClass(Class<T> clazz) {
        return Hermes.getUtilityClassInService(HermesService.HermesService0.class, clazz);
    }

    public static <T> T getUtilityClassInService(Class<? extends HermesService> service, Class<T> clazz) {
        TypeUtils.validateServiceInterface(clazz);
        ObjectWrapper object = new ObjectWrapper(clazz, 5);
        Sender sender = SenderDesignator.getPostOffice(service, 2, object);
        try {
            Reply reply = sender.send(null, null);
            if (reply != null && !reply.success()) {
                Log.e((String)TAG, (String)("Error occurs during getting utility class. Error code: " + reply.getErrorCode()));
                Log.e((String)TAG, (String)("Error message: " + reply.getMessage()));
                return null;
            }
        }
        catch (HermesException e) {
            e.printStackTrace();
            return null;
        }
        object.setType(4);
        return Hermes.getProxy(service, object);
    }

    public static void connect(Context context) {
        Hermes.connect(context, HermesService.HermesService0.class);
    }

    public static void connect(Context context, Class<? extends HermesService> service) {
        CHANNEL.bind(context, service);
    }

    public static void disconnect(Context context) {
        Hermes.disconnect(context, HermesService.HermesService0.class);
    }

    public static void disconnect(Context context, Class<? extends HermesService> service) {
        CHANNEL.unbind(context, service);
    }

    public static boolean isConnected() {
        return Hermes.isConnected(HermesService.HermesService0.class);
    }

    public static boolean isConnected(Class<? extends HermesService> service) {
        return CHANNEL.isConnected(service);
    }

    public static void setHermesListener(HermesListener listener) {
        CHANNEL.setHermesListener(listener);
    }
}

