/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.hermes.receiver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import xiaofei.library.hermes.receiver.Receiver;
import xiaofei.library.hermes.util.HermesException;
import xiaofei.library.hermes.util.TypeUtils;
import xiaofei.library.hermes.wrapper.MethodWrapper;
import xiaofei.library.hermes.wrapper.ObjectWrapper;
import xiaofei.library.hermes.wrapper.ParameterWrapper;

public class UtilityReceiver
extends Receiver {
    private Method mMethod;
    private Class<?> mClass;

    public UtilityReceiver(ObjectWrapper objectWrapper) throws HermesException {
        super(objectWrapper);
        Class<?> clazz = TYPE_CENTER.getClassType(objectWrapper);
        TypeUtils.validateAccessible(clazz);
        this.mClass = clazz;
    }

    @Override
    protected void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws HermesException {
        Method method = TYPE_CENTER.getMethod(this.mClass, methodWrapper);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new HermesException(5, "Only static methods can be invoked on the utility class " + this.mClass.getName() + ". Please modify the method: " + this.mMethod);
        }
        TypeUtils.validateAccessible(method);
        this.mMethod = method;
    }

    @Override
    protected Object invokeMethod() throws HermesException {
        ReflectiveOperationException exception;
        try {
            return this.mMethod.invoke(null, this.getParameters());
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        exception.printStackTrace();
        throw new HermesException(17, "Error occurs when invoking method " + this.mMethod + ".", exception);
    }
}

