/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.text.compiler;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import xfy.fakeview.library.text.block.DefaultDrawableBlock;
import xfy.fakeview.library.text.block.DefaultDrawableBlockList;
import xfy.fakeview.library.text.compiler.DefaultTextCompiler;
import xfy.fakeview.library.text.compiler.ITextCompiler;
import xfy.fakeview.library.text.param.SpecialStyleParams;
import xfy.fakeview.library.text.utils.IDrawableStats;

public class DrawableTextCompiler
extends DefaultTextCompiler {
    private static volatile DrawableTextCompiler compiler;
    protected char D_START = (char)91;
    protected char D_END = (char)93;
    private ResourceAdapter adapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DrawableTextCompiler getCompiler() {
        if (compiler != null) return compiler;
        Class<DrawableTextCompiler> clazz = DrawableTextCompiler.class;
        synchronized (DrawableTextCompiler.class) {
            if (compiler != null) return compiler;
            compiler = new DrawableTextCompiler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return compiler;
        }
    }

    protected DrawableTextCompiler() {
    }

    public DrawableTextCompiler(ITextCompiler<DefaultDrawableBlockList> innerCompiler) {
        super(innerCompiler);
    }

    public void setResourceAdapter(ResourceAdapter adapter) {
        this.adapter = adapter;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.adapter;
    }

    @Override
    public void compileInternal(@NonNull DefaultDrawableBlockList list, @NonNull CharSequence text, int start, int end, @Nullable SpecialStyleParams specialStyleParams) {
        if (this.adapter == null) {
            super.compileInternal(list, text, start, end, specialStyleParams);
            return;
        }
        this.adapter.beforeCompile();
        this.compileDrawbleText(list, text, start, end, specialStyleParams);
    }

    @Override
    protected boolean compileSpecialText(DefaultDrawableBlockList list, CharSequence t, @Nullable SpecialStyleParams specialStyleParams) {
        int res = this.adapter.parseRes(t);
        if (res <= 0) {
            Drawable d = this.adapter.parseDrawable(t);
            if (d != null) {
                if (d instanceof IDrawableStats) {
                    list.add(DefaultDrawableBlock.createNeedSetCallbackDrawableBlock(t, d));
                } else {
                    list.add(DefaultDrawableBlock.createSpecialDrawableBlock(t, d));
                }
                return true;
            }
        } else {
            list.add(DefaultDrawableBlock.createDrawableBlock(t, res));
            return true;
        }
        return false;
    }

    private void compileDrawbleText(DefaultDrawableBlockList list, @NonNull CharSequence text, int start, int end, @Nullable SpecialStyleParams specialStyleParams) {
        int index;
        boolean haveStart = false;
        int lastStartIndex = -1;
        int lastEndIndex = start;
        for (index = start; index < end; ++index) {
            char c = text.charAt(index);
            if (c == this.D_START) {
                lastStartIndex = index;
                haveStart = true;
                continue;
            }
            if (c != this.D_END) continue;
            if (haveStart) {
                CharSequence parseText;
                if (lastEndIndex != lastStartIndex) {
                    super.compileInternal(list, text, lastEndIndex, lastStartIndex, specialStyleParams);
                    lastEndIndex = lastStartIndex;
                }
                if (this.compileSpecialText(list, parseText = text.subSequence(lastStartIndex, index + 1), specialStyleParams)) {
                    lastEndIndex = index + 1;
                }
            }
            haveStart = false;
        }
        if (lastEndIndex != index) {
            super.compileInternal(list, text, lastEndIndex, index, specialStyleParams);
        }
    }

    public static interface ResourceAdapter {
        public void beforeCompile();

        public int parseRes(@NonNull CharSequence var1);

        public Drawable parseDrawable(@NonNull CharSequence var1);
    }
}

