/*
 * Decompiled with CFR 0.152.
 */
package xfy.fakeview.library.fview.utils;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;

public class FViewDebugTool {
    private Paint debugPaint = new Paint(1);
    private Path debugPath;

    public FViewDebugTool() {
        this.debugPaint.setStyle(Paint.Style.STROKE);
        this.debugPaint.setStrokeWidth(5.0f);
        this.debugPaint.setColor(-65536);
        this.debugPath = new Path();
    }

    public FViewDebugTool withColor(int color) {
        this.debugPaint.setColor(color);
        return this;
    }

    public FViewDebugTool withStrokeWidth(float width) {
        this.debugPaint.setStrokeWidth(width);
        return this;
    }

    public FViewDebugTool withBounds(Rect bounds) {
        this.debugPath.addRect((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, Path.Direction.CCW);
        return this;
    }

    public FViewDebugTool withBounds(int l, int t, int r, int b) {
        this.debugPath.addRect((float)l, (float)t, (float)r, (float)b, Path.Direction.CCW);
        return this;
    }

    public void draw(Canvas canvas) {
        canvas.drawPath(this.debugPath, this.debugPaint);
    }
}

